/******************************************************
-Class [varEvent]

The [varEvent] is used to trigger an event when input data state changes.

目的:
    入力された状態の[立ち上がり],[立ち下がり]を検知する
    [Rise(0->1)],[Fall(1->0)]
    Sbdbt用として作成,流用可
    
使い方:
Public Member Functions:

    varEvent <useName>          //宣言
    .input((int)<inputData>)    //(void)検出したい変数(Data)を引数に代入
    .getRise()                  //(int)立ち上がり検知 検出時は(int)1,それ以外は(int)0を返す
    .getFall()                  //(int)立ち下がり検知 検出時は(int)1,それ以外は(int)0を返す
        
***************************************************************/

class varEvent {
public:
    void input(int inputState) {
        valState = ((valState<<1)|inputState)&3;
        if(valState == 1) {
            riseState = 1;
            fallState = 0;
        } else if(valState == 2){
            riseState = 0;
            fallState = 1;
        } else {
            riseState = 0;
            fallState = 0;
        }
    }
    
    int getRise(){
        return riseState;   
    }
    
    int getFall(){
        return fallState;   
    }
    
private:
    int inputState, valState;
    int riseState, fallState;
};