/*
    ★サイクリック★
サイクリックでピンをHigh/Lowするクラスです。
①定義方法
    Cyclic_IO [name]( pin );
                    |
                    +--サイクリックでHigh/LowさせたいDigitalOutピン 
                    
②関数
    その１
      void cyclic(int state)  :  ピンをサイクリックでHigh/Lowさせる関数。
                        |
                        +-- ボタンの入力状況を1 or 0で入れてください。
                            DigitalInのRead()を入れると一発で動きます。
     
     その２               
     int getState() :   ピンの出力状況を1 or 0で返す関数。
                        出力されてたら1、されてなかったら0を返します
*/

#ifndef CYCLIC_H
#define CYCLIC_H

#include "mbed.h"

class Cyclic_IO 
{
  public:
    Cyclic_IO(PinName pin) : gpio(pin){}
    
    void cyclic(int state)
    {
        if(state)
        {
            if(flag == false)
            {
                gpio = !gpio; 
            }
            flag = true;
        }
        else flag = false;
    }
    
    int getState()
    {
        return (int)gpio; 
    }
    
  private:  
    DigitalOut gpio;
    bool flag;
};

#endif