/*
MotorDrive Name(cw, ccw, pwm);

setup(Frequency, DutyLimit)
MotorDrive関数のセットアップ
pwm周波数,pwmの最高値を決める

output(duty)
dutyを出力する
*/

class MotorDrive
{
public  :
    MotorDrive (PinName Cw, PinName Ccw, PinName Pwm) : cw(Cw), ccw(Ccw), pwm(Pwm) {
        cw      = 0;
        ccw     = 0;
        pwm     = 0;
    }

    void setup(float Frequency, float Dutylimit) {
        float Period = 1 / Frequency;
        pwm.period(Period);
        limit = Dutylimit;
    }

    void output(float duty) {
        if (duty > 0) {
            ccw  = 0;
            cw  = 1;
            if (duty > limit) {
                duty = limit;
            }
        } else {
            cw  = 0;
            ccw  = 1;
            if (duty < -limit) {
                duty = -limit;
            }
        }
        
        pwm = fabs(duty);
    }

private :
    DigitalOut cw;
    DigitalOut ccw;
    PwmOut pwm;
    
    float limit;
};