/*
    ★サイクリック★
サイクリックでピンをHigh/Lowするクラスです。
①定義方法
    Cyclic_IO [name]( pin );
                    |
                    +--サイクリックでHigh/LowさせたいDigitalOutピン 
                    
②関数
    その１
      void cyclic(int state)  :  ピンをサイクリックでHigh/Lowさせる関数。
                        |
                        +-- ボタンの入力状況を1 or 0で入れてください。
                            DigitalInのRead()を入れると一発で動きます。
     
     その２               
     int getState() :   ピンの出力状況を1 or 0で返す関数。
                        出力されてたら1、されてなかったら0を返します
*/

#ifndef CYLINDER_H
#define CYLINDER_H

#include "mbed.h"

class Cylinder 
{
  public:
    Cylinder(PinName pin_in,PinName pin_out):cylinder_in(pin_in),cylinder_out(pin_out){
        cylinder_in = 1;
        cylinder_out = 0;
        }
    
    void cyclic(int state)
    {
        if(state)
        {
            if(flag == false)
            {
                cylinder_in = !cylinder_in;
                cylinder_out = !cylinder_out;
            }
            flag = true;
        }
        else flag = false;
    }
    
    int getInState()
    {
        return (int)cylinder_in; 
    }
    
    int getOutState()
    {
        return (int)cylinder_out; 
    }
    
  private:  
    DigitalOut cylinder_in;
    DigitalOut cylinder_out;
    bool flag;
};

#endif