/*************************************************************************************************
frdm_simple_adc

**************************************************************************************************/
#include "mbed.h"

/* Defines */
#define READ_INTERVAL 0.1 //Seconds

/* Objects */
Serial pc(USBTX, USBRX);
AnalogIn analog0(PTB0);
AnalogIn analog1(PTB1);
AnalogIn analog2(PTB2);
AnalogIn analog3(PTB3);
AnalogIn analog4(PTC2);
AnalogIn analog5(PTC1);

/* Global Variales */
float adcRead0, adcRead1, adcRead2, adcRead3, adcRead4, adcRead5;

/* Function Prototypes */

/* Main Routine */
int main()
{
    pc.printf("\nElapsed Time[ms], PTB0[V], PTB1[V], PTB2[V], PTB3[V], PTC2[V], PTC1[V]\n");
    
    while(1)
    {     
        /* Poll Analog Sensors */       
        adcRead0 = analog0*3.3;
        adcRead1 = analog1*3.3;
        adcRead2 = analog2*3.3;
        adcRead3 = analog3*3.3;
        adcRead4 = analog4*3.3;
        adcRead5 = analog5*3.3;
        
        /* Print ADC values to Terminal */
        pc.printf("%1.3f, %1.3f, %1.3f, %1.3f, %1.3f, %1.3f\n\r", 
                    adcRead0, adcRead1, adcRead2, adcRead3, adcRead4, adcRead5);
        
        /* Delay for set time interval and increment time counter */
        wait(READ_INTERVAL);
    }
}