/*
 * eConais EC19D01
 * AT command test
 * serial interface, machine mode 
 */

#include "mbed.h"

DigitalOut led1(LED1), led2(LED2);
Serial pc(USBTX, USBRX);
Serial ec(p9, p10);
DigitalOut rts(p11), exton(p16);
DigitalIn cts(p12);

void command (char *cmd) {
    int num, len = 0;
    char *buf;
    char c;

    if (strncmp(cmd, "AT", 2)) return;

    num = atoi(&cmd[2]);
    buf = strstr(cmd, ",");
    if (buf) {
        buf ++;
        len = strlen(buf);
    }
    printf("\r\nAT %d %d '%s'\r\n", num, len, buf);

    rts = 1;
    for (;;) {
        if (ec.readable()) {
            c = ec.getc();
            if (c >= 0x20 && c < 0x80) {
                pc.putc(c);
            } else {
                pc.printf(" %02x ",c);
            }
            if (c == 'Y') break;
        }
    }
    ec.printf("%c%c%c", num, len & 0xff, (len >> 8) & 0xff);
    
    if (len) {
      for (;;) {
        if (ec.readable()) {
            c = ec.getc();
            if (c >= 0x20 && c < 0x80) {
                pc.putc(c);
            } else {
                pc.printf(" %02x ",c);
            }
            if (c == 'T') break;
        }
      }
      ec.printf("%s", buf);
    }
    rts = 0;
    pc.printf("\r\n----\r\n");
}

int main() {
    char buf[80];
    int count = 0;
    unsigned char c;

    rts = 0;
    pc.baud(115200);
    ec.baud(115200);
    exton = 1;
    wait_ms(100);
    exton = 0;
    wait_ms(300);

    led1 = 1;
    while(1) {
        if (ec.readable()) {
            c = ec.getc();
            if ((c >= 0x20 && c < 0x80) || c == '\r' || c == '\n') {
                pc.putc(c);
            } else {
                pc.printf(" %02x ",c);
            }
        }

        if (pc.readable()) {
            c = pc.getc();
            if (c == '\r' || c == '\n') {
              if (count) {
                buf[count] = 0;
                led2 = 1;
                command(buf);
                led2 = 0;
              }
              count = 0;
            } else
            if (count < 79) {
                buf[count++] = c;
                pc.putc(c);
            }
        }
    }
}
