#include "EC19.h"

extern DigitalOut led1, led2, led3, led4;
extern Serial pc;

void EC19::recvData (char c) {
    static int cid, sub, len, count;

    pc.putc(c);    
#ifdef DEBUG_DUMP
    if (c < 0x20 || c >= 0x7f) {
        std::printf("_%02x", c);
    } else {
        std::printf("_%c", c);
    }
#endif

    switch (_state.mode) {
    case MODE_COMMAND:
        if (c == '\r' || c == '\n') {
            _state.buf[_state.n] = 0;
            if (_state.n) {
                led2 = 1;
                parseMessage();
                led2 = 0;
            }
            _state.n = 0;
        } else {
            if (_state.n < CFG_BUF_SIZE - 1) {
                _state.buf[_state.n] = c;
                _state.n ++;
            }
        }
        break;
    case MODE_DATA:
        _state.n ++;
        if (_state.n >= _state.datalen) {
            _state.n = 0;
            _state.mode = MODE_COMMAND;
        }
        break;
    }
}

#define MSG_TABLE_NUM 12
int EC19::parseMessage () {
    int i;
    static int type = -1;
    static const struct MSG_TABLE {
        const char msg[16];
        void (EC19::*func)(const char*);
    } msg_table[MSG_TABLE_NUM] = {
      {"IP",                    &EC19::msgIp},
      {"MAC",                   &EC19::msgMac},
      {"DHCP",                  &EC19::msgDhcp},
      {"STATUS",                &EC19::msgStatus},
      {"CLIENT",                &EC19::msgClient},
      {"AP",                    &EC19::msgAp},
      {"RSSI",                  &EC19::msgRssi},
      {"TCP_CONNECT",           &EC19::msgTcpConnect},
      {"UDP_CONNECT",           &EC19::msgUdpConnect},
      {"TCP_RECEIVED",          &EC19::msgTcpReceived},
      {"UDP_RECEIVED",          &EC19::msgUdpReceived},
      {"HOST_EVENT",            &EC19::msgHostEvent},
    };

//    DBG("parse %d '%s'\r\n", type, _state.buf);
    if (_state.n == 3 && strncmp(_state.buf, "TXE", 3) == NULL) {
        if (_state.datalen) {
            _state.mode = MODE_DATA;
        }
        if (! _state.failure) {
            _state.ok = true;
        }
        type = -1;
        led3 = 0;
    } else
    if (type >= 0) {
        led4 = 1;
        (this->*(msg_table[type].func))(_state.buf);
        led4 = 0;
    } else
    if (strncmp(_state.buf, "READY", 5) == NULL) {
        _state.ready = true;
    } else
    if (strncmp(_state.buf, "DWAIT", 5) == NULL) {
        _state.dwait = true;
    } else
    if (strncmp(_state.buf, "CMDOK", 5) == NULL) {
        //
    } else
    if (strncmp(_state.buf, "CMDERR", 6) == NULL) {
        _state.failure = true;
    } else
    if (strncmp(_state.buf, "TXS : ", 6) == NULL) {
        for (i = 0; i < MSG_TABLE_NUM; i ++) {
            if (strncmp(&_state.buf[6], msg_table[i].msg, strlen(msg_table[i].msg)) == NULL) {
                type = i;
                led3 = 1;
                break;
            }
        }
    } else {
        return -1;
    }
    return 0;
}


void EC19::msgIp (const char *buf) {
    if (strncmp(buf, "IP : ", 5) == NULL) {
        strncpy(_state.ip, &buf[5], sizeof(_state.ip));
    } else
    if (strncmp(buf, "Subnet : ", 9) == NULL) {
        strncpy(_state.netmask, &buf[9], sizeof(_state.netmask));
    } else
    if (strncmp(buf, "Gateway : ", 10) == NULL) {
        strncpy(_state.gateway, &buf[10], sizeof(_state.gateway));
    }
}

void EC19::msgMac (const char *buf) {
    if (strncmp(buf, "MAC : ", 6) == NULL) {
        strncpy(_state.mac, &buf[6], sizeof(_state.mac));
    }
}

void EC19::msgDhcp (const char *buf) {
    if (strncmp(buf, "DHCP : ", 7) == NULL) {
    }
}

void EC19::msgStatus (const char *buf) {
    if (strncmp(buf, "CONNECTED : ", 12) == NULL) {
        switch (buf[12]) {
        case 'Y':
        case '1':
            _state.associated = true;
            break;
        case 'N':
        case '0':
        default:
            _state.associated = false;
            break;
        }
    } else
    if (strncmp(buf, "SSID : ", 7) == NULL) {
    }
}

void EC19::msgClient (const char *buf) {
    if (strncmp(buf, "CONNECTED : ", 12) == NULL) {
        switch (buf[12]) {
        case 'Y':
        case '1':
            _state.associated = true;
            break;
        case 'N':
        case '0':
        default:
            _state.associated = false;
            break;
        }
    } else
    if (strncmp(buf, "DHCP : ", 7) == NULL) {
        if (buf[7] == '1') {
            _state.ip[0] = 0;
            _state.netmask[0] = 0;
            _state.gateway[0] = 0;
            _state.nameserver[0] = 0;
        }
    }
}

void EC19::msgAp (const char *buf) {
    if (strncmp(buf, "STARTED : ", 10) == NULL) {
        _state.associated = buf[10] == 'Y' ? true : false;
    }
}

void EC19::msgRssi (const char *buf) {
    if (strncmp(buf, "RSSI : ", 7) == NULL) {
        _state.rssi = atoi(&buf[7]);
    }
}

void EC19::msgTcpConnect (const char *buf) {
    int state;
    if (strncmp(buf, "TCP_CONN_ID : ", 14) == NULL) {
        _state.cid = atoi(&buf[14]);
    } else
    if (strncmp(buf, "TCP_STATE : ", 12) == NULL) {
        state = atoi(&buf[12]);
    }
}

void EC19::msgUdpConnect (const char *buf) {
    int state;
    if (strncmp(buf, "UDP_CONN_ID : ", 14) == NULL) {
        _state.cid = atoi(&buf[14]);
    } else
    if (strncmp(buf, "TCP_STATE : ", 12) == NULL) {
        state = atoi(&buf[12]);
    }
}

void EC19::msgHostEvent (const char *buf) {
    if (strncmp(buf, "IP : ", 5) == NULL) {
        strncpy(_state.resolv, &buf[5], sizeof(_state.resolv));
    }
}

void EC19::msgTcpReceived (const char *buf) {
    if (strncmp(buf, "TCP_CONN_ID : ", 14) == NULL) {
        _state.cid = atoi(&buf[14]);
    } else
    if (strncmp(buf, "TCP_DATALEN : ", 14) == NULL) {
        _state.datalen = atoi(&buf[14]);
    }
}

void EC19::msgUdpReceived (const char *buf) {
    if (strncmp(buf, "UDP_CONN_ID : ", 14) == NULL) {
        _state.cid = atoi(&buf[14]);
    } else
    if (strncmp(buf, "UDP_DATALEN : ", 14) == NULL) {
        _state.datalen = atoi(&buf[14]);
    }
}
