#include "EC19.h"

void EC19::setReset (bool flg) {
    if (flg) {
        _shutdown = 0;
    } else {
        _shutdown = 1;
    }
}

void EC19::isrUart () {
    recvData(getUart());
//    _state.buf->queue(getUart());
}

int EC19::getUart () {
#ifdef CFG_UART_DIRECT
    return _uart->RBR;
#else
    return _ec.getc();
#endif
}
 
void EC19::putUart (char c) {
#ifdef CFG_UART_DIRECT
    while(!(_uart->LSR & (1<<5)));
    _uart->THR = c;
#else
    _ec.putc(c);
#endif
}

void EC19::setRts (bool flg) {
    if (flg) {
        // low
        if (_flow == 1) {
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368) || defined(TARGET_LPC11U24) || defined(TARGET_LPC4088) || defined(TARGET_LPC176X) || defined(TARGET_LPC11UXX) || defined(TARGET_LPC408X)
            _uart->MCR |= (1<<6); // RTSEN
#endif
        } else
        if (_flow == 2) {
            if (_rts) {
                _rts->write(0); // low
            }
        }
    } else {
        // high
        if (_flow == 1) {
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368) || defined(TARGET_LPC11U24) || defined(TARGET_LPC4088) || defined(TARGET_LPC176X) || defined(TARGET_LPC11UXX) || defined(TARGET_LPC408X)
            _uart->MCR &= ~(1<<6); // RTS off
            _uart->MCR &= ~(1<<1);
#endif
        } else
        if (_flow == 2) {
            if (_rts) {
                _rts->write(1); // high
            }
        }
    }
}

void EC19::initUart (PinName cts, PinName rts, int baud) {
 
    _baud = baud;
    if (_baud) _ec.baud(_baud);
    _ec.attach(this, &EC19::isrUart, Serial::RxIrq);
 
    _cts = NULL;
    _rts = NULL;
    _flow = 0;
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368) || defined(TARGET_LPC176X)
    _uart = LPC_UART1;
    if (cts == p12) { // CTS input (P0_17)
        _uart->MCR |= (1<<7); // CTSEN
        LPC_PINCON->PINSEL1 &= ~(3 << 2);
        LPC_PINCON->PINSEL1 |= (1 << 2); // UART CTS
    } else
    if (cts != NC) {
        _cts = new DigitalIn(cts);
    }
#elif defined(TARGET_LPC11U24) || defined(TARGET_LPC11UXX)
    _uart = LPC_USART;
    if (cts == p21) { // CTS input (P0_7)
        _uart->MCR |= (1<<7); // CTSEN
        LPC_IOCON->PIO0_7 &= ~0x07;
        LPC_IOCON->PIO0_7 |= 0x01; // UART CTS
    } else
    if (cts != NC) {
        _cts = new DigitalIn(cts);
    }
#elif defined(TARGET_LPC4088) || defined(TARGET_LPC408X)
    _uart = (LPC_UART1_TypeDef*)LPC_UART2;
    if (cts != NC) {
        _cts = new DigitalIn(cts);
    }
#else
    if (cts != NC) {
        _cts = new DigitalIn(cts);
    }
#endif
    if (rts != NC) {
        _rts = new DigitalOut(rts);
        setRts(true);
        _flow = 2;
    }
}



