#include "EC19.h"

void EC19::clearFlags () {
    _state.ok = false;
    _state.failure = false;
    _state.ready = false;
    _state.dwait = false;
    _state.n = 0;
}
 
int EC19::sendCommand (int cmd, const char *data, int length, int timeout) {
    int i;
    Timer t;

    INFO("command: 'AT%d' %d\r\n", cmd, length);
    setRts(false);
    t.reset();
    t.start();
    while (! _state.ready) {
        if (t.read_ms() > timeout) {
            setRts(true);
            WARN("timeout r\r\n");
            return -1;
        }
    }
    t.stop();

    clearFlags();
    putUart(cmd);
    putUart(length & 0xff);
    putUart((length >> 8) & 0xff);

    if (length) {
        t.reset();
        t.start();
        while (! _state.dwait) {
            if (t.read_ms() > timeout) {
                setRts(true);
                WARN("timeout d\r\n");
                return -1;
            }
        }
        for (i = 0; i < length; i ++) {
            putUart(data[i]);
        }
    }
    setRts(true);

    if (timeout) {
        t.reset();
        t.start();
        for (;;) {
            if (_state.ok) break;
            if (_state.failure) {
                WARN("failure\r\n");
                return -1;
            }
            if (t.read_ms() > timeout) {
                WARN("timeout\r\n");
                return -1;
            }
        }
        t.stop();
    }
    INFO("ok\r\n");

    return 0;
}



int EC19::cmdBaud (int baud) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%d", baud);
    return sendCommand(5, cmd, strlen(cmd));
}

int EC19::cmdAssociate (Security sec, const char *ssid, const char *phrase, int key) {
    char cmd[CFG_CMD_SIZE];

    if (!ssid && !phrase) {
        return sendCommand(10, "?", 1);
    }

    switch (sec) {
    case SEC_OPEN:
    case SEC_WPA_PSK:
        if (phrase) {
            sprintf(cmd, "%s,%s", ssid, phrase);
        } else {
            sprintf(cmd, "%s", ssid);
        }
        return sendCommand(10, cmd, strlen(cmd), CFG_TIMEOUT);
    case SEC_WEP:
        sprintf(cmd, "%s,%s,%d", ssid, phrase, key);
        return sendCommand(10, cmd, strlen(cmd), CFG_TIMEOUT);
    }
    return -1;
}

int EC19::cmdDissociate () {
    return sendCommand(116, NULL, 0, CFG_TIMEOUT);
}

int EC19::cmdMac (const char *mac) {
    char cmd[CFG_CMD_SIZE];
    int r;
    const char xmac[] = "00:1D:C9:01:99:99";

    if (mac) {
        sprintf(cmd, "1,%s", mac);
        r = sendCommand(13, cmd, strlen(cmd));
    } else {
        r = sendCommand(13, "0", 1);
        if (!r && strncmp(_state.mac, xmac, 17) == 0) {
            r = -1;
        }
    }
    return r;
}

int EC19::cmdWps (Security sec, const char *pin) {
    char cmd[CFG_CMD_SIZE];

    switch (sec) {
    case SEC_WPS_BUTTON:
        return sendCommand(20, "0", 1, CFG_TIMEOUT);
    case SEC_WPS_PIN:
        sprintf(cmd, "1,%s", pin);
        return sendCommand(20, cmd, strlen(cmd), CFG_TIMEOUT);
    }
    return -1;
}

int EC19::cmdPowerMode (int mode, int interval) {
    char cmd[CFG_CMD_SIZE];

    switch (mode) {
    case 0:
        return sendCommand(23, "0", 1);
    case 1:
    case 2:
        if (interval) {
            sprintf(cmd, "%d,0,%d", mode, interval);
        } else {
            sprintf(cmd, "%d,1", mode);
        }
        return sendCommand(23, cmd, strlen(cmd));
    case 3:
    }
    return -1;
}

int EC19::cmdRssi () {
    return sendCommand(24, NULL, 0);
}

int EC19::cmdSoftAp (Security sec, const char *ssid, const char *phrase, int ch) {
    char cmd[CFG_CMD_SIZE];

    if (!ssid && !phrase) {
        return sendCommand(40, "?", 1);
    }

    switch (sec) {
    case SEC_OPEN:
        return sendCommand(40, ssid, strlen(ssid), CFG_TIMEOUT);
    case SEC_WPA_PSK:
        if (ch) {
            sprintf(cmd, "%s,%s,%d", ssid, phrase, ch);
        } else {
            sprintf(cmd, "%s,%s", ssid, phrase);
        }
        return sendCommand(40, cmd, strlen(cmd), CFG_TIMEOUT);
    }
    return -1;
}

int EC19::cmdTcpClient (const char *remote, int port) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%s,%d", remote, port);
    return sendCommand(63, cmd, strlen(cmd));
}

int EC19::cmdTcpServer (int port) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%d", port);
    return sendCommand(65, cmd, strlen(cmd));
}

int EC19::cmdUdpClient (const char *remote, int port) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%s,%d", remote, port);
    return sendCommand(70, cmd, strlen(cmd));
}

int EC19::cmdUdpServer (int port) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%d", port);
    return sendCommand(73, cmd, strlen(cmd));
}

int EC19::cmdClose (int cid) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%d", cid);
    return sendCommand(72, cmd, strlen(cmd));
}

int EC19::cmdLookup (const char *name) {
    return sendCommand(76, name, strlen(name));
}

int EC19::cmdCreateProfile (int pid, Security sec, const char *ssid, const char *phrase,
  char *ip, char *netmask, char *gateway, char *dns, int ap, int ch) {
    char cmd[CFG_CMD_SIZE];

    switch (sec) {
    case SEC_WPS_BUTTON:
        sprintf(cmd, "%d,enc,%d,role,%d", pid, sec, ap ? 1 : 0);
        break;
    case SEC_WPS_PIN:
        sprintf(cmd, "%d,pin,%s,enc,%d,role,%d", pid, phrase, sec, ap ? 1 : 0);
        break;
    default:
        sprintf(cmd, "%d,ssid,%s,pass,%s,enc,%d,role,%d", pid, ssid, phrase, sec, ap ? 1 : 0);
        break;
    }
    if (ip) {
        sprintf(&cmd[strlen(cmd)], "ipstat,1,ip,%s,nm,%s,gw,%s,dns,%s", ip, netmask, gateway, dns);
    }
    if (ch) {
        sprintf(&cmd[strlen(cmd)], ",chan,%d", ch);
    }
    return sendCommand(110, cmd, strlen(cmd));
}

int EC19::cmdEnableProfile (int pid) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "%d", pid);
    return sendCommand(111, cmd, strlen(cmd));
}

int EC19::cmdAutoProfile (int retry, int num) {
    char cmd[CFG_CMD_SIZE];

    sprintf(cmd, "1,%d,%d", retry, num);
    return sendCommand(112, cmd, strlen(cmd));
}
