#include "EC19.h"

EC19 * EC19::_inst;

EC19::EC19(PinName tx, PinName rx, PinName cts, PinName rts, PinName shutdown, int baud) :
    _ec(tx, rx), _shutdown(shutdown)
{
    _inst = this;
    memset(&_state, 0, sizeof(_state));

    _state.initialized = false;
    _state.buf = (char*)malloc(CFG_BUF_SIZE);
//    _state.buf = new CircBuffer<char>(CFG_BUF_SIZE);

    setReset(true);
    initUart(cts, rts, baud);
    wait_ms(10);
    setReset(false);
    wait_ms(100);
}

int EC19::join () {
    Timer t;

    cmdMac(NULL);
    cmdAssociate(SEC_WPA_PSK, "suge", "okini3939");

    t.reset();
    t.start();
    for (;;) {
        if (_state.associated && _state.gateway[0] != 0) break;
        if (_state.failure || t.read_ms() > CFG_TIMEOUT) return -1;
        wait_ms(10);
    }
    t.stop();
    return 0;
}

int EC19::dissociate () {
    Timer t;

    cmdRssi();
    cmdPowerMode(0, 0);

    cmdDissociate();
    t.reset();
    t.start();
    for (;;) {
        if (! _state.associated) break;
        if (_state.failure || t.read_ms() > CFG_TIMEOUT) return -1;
        wait_ms(10);
    }
    t.stop();
    return 0;
}

void EC19::poll () {
    char c;
/*
    while (_state.buf->dequeue(&c)) {
        recvData(c);
    }
*/
}

