//state used to remember previous characters read in a button message
//global variables for main and interrupt routine
#include "mbed.h"
volatile bool button_ready = 0;
volatile int  bnum = 0;
volatile int  bhit  ;
Serial Blue(p28,p27);
enum statetype {start = 0, got_exclm, got_B, got_num, got_hit};
statetype state = start;
void parse_message()
{
    switch (state) {
        case start:
            if (Blue.getc()=='!') state = got_exclm;
            else state = start;
            break;
        case got_exclm:
            if (Blue.getc() == 'B') state = got_B;
            else state = start;
            break;
        case got_B:
            bnum = Blue.getc();
            state = got_num;
            break;
        case got_num:
            bhit = Blue.getc();
            state = got_hit;
            break;
        case got_hit:
            if (Blue.getc() == char(~('!' + ' B' + bnum + bhit))) button_ready = 1;
            state = start;
            break;
        default:
            Blue.getc();
            state = start;
    }
}