// Include header files for platform
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "Shiftbrite.h"
#include <vector>
#include "MMA8452.h"    // for accelerometer

// Include header files for robot project
#include "globals.h"
#include "map_public.h"
#include "robot.h"
#include "cars.h"

//Platform initialization
DigitalIn left_pb(p24);  // push bottom
DigitalIn right_pb(p21); // push bottom
DigitalIn up_pb(p22);    // push bottom
DigitalIn down_pb(p23);  // push bottom
uLCD_4DGL uLCD(p9,p10,p11); // LCD (serial tx, serial rx, reset pin;)
AnalogOut DACout(p18);      // speaker
wave_player waver(&DACout); // wav player
SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card and filesystem (mosi, miso, sck, cs)
Serial pc(USBTX,USBRX);     // used by Accelerometer
MMA8452 acc(p28, p27, 100000); // Accelerometer
DigitalOut myled(LED1);
void gameMenu();
void playSound(char * wav)
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    if(wave_file == NULL) {
        uLCD.locate(9,0);
        uLCD.printf("ERROR_SD");
        uLCD.cls();
        return;
    }

    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}

int main()
{
    // Initialize the buttons
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed
    up_pb.mode(PullUp);    //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    down_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    gameMenu();
    uLCD.background_color(BLACK);
    uLCD.cls();  

   ///////////////////////////////////////////////////////////////
    // Initialize the timer
    /// [Example of time control implementation]
    /// Here is a rough example to implement the timer control <br><br>
    int tick, pre_tick;
    srand (time(NULL));
    Timer timer;
    timer.start();
    tick = timer.read_ms();
    pre_tick = tick;

    /// [Example of the game control implementation]
    /// Here is the example to initialize the game <br><br>
    uLCD.cls();
    map_init();
    double x_, y_, z_;
    double x=3;
    double y=0;
    double a=3;
    double b=11;
    double score=0;
    bool end=0;
    int p =4;
   /* uLCD.filled_rectangle(20, 20, 30, 30, RED);
    uLCD.filled_circle(20, 23, 1, BLACK);
    uLCD.filled_circle(20, 27, 1, BLACK);
    uLCD.line(30,25,35,25, BLACK);*/
    //robot_init(x,y,score,end);
     // Init car 1
   /* car_t car1;
    car_t * redcar = &car1;
    redcar -> car_color = RED;
    redcar -> lane = 1;
    redcar -> car_motion = (CAR_MOTION) 0;
    
    car_init(redcar);
    drive(redcar);
    //Init Car 2
    car_t car2;
    car_t * bluecar = &car2;
    bluecar -> car_color = BLUE;
    bluecar -> lane = 2;
    bluecar -> car_motion = (CAR_MOTION) 0;
    
    car_init(bluecar);
    drive(bluecar);
    
    //Init Car 3
    
    car_t car3;
    car_t * whitecar = &car3;
    whitecar -> car_color = WHITE;
    whitecar -> lane = 3;
    whitecar -> car_motion = (CAR_MOTION) 0;
    
    car_init(whitecar);
    drive(whitecar);
    
    //begin sound
    playSound("/sd/wavfiles/BUZZER.wav"); 

    /// 1. Begin the game loop
    while(1) {
         if((whitecar -> car_blk_x == x && whitecar -> car_blk_y == y)
        || (redcar -> car_blk_x == x && redcar -> car_blk_y == y)
            || (bluecar -> car_blk_x == x && bluecar -> car_blk_y == y) ) {
        collision();
        }
         acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
        uLCD.locate(0,0);
         uLCD.printf("sensor x%4.1f y%4.1f\n",x_,y_); //You could remove this code if you already make the accelerometer work.
        if(x_>=0.3){                  //READING INPUTS FROM ACCELEROMETER
 robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x+=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}
else if(x_<=-0.3) {
robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x-=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}
else if(y_>0.3) {
robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=16) {
                    x+=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}
else if(y_< -0.3) {
robot_clear(x,y);
                map_draw_grid(x,y);
                if(y!=15) {
                    y=y+1;
                } else {
                    y=0;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}
      
        tick = timer.read_ms(); // Read current time
        if (!end){
            uLCD.locate(0,1);
          //  uLCD.printf("Score x%4.1f ",score); 
        } else {
            uLCD.locate(0,1);
            uLCD.printf("YOU WIN!!!!!");
        }
        //acc.readXYZGravity(&x,&y,&z); //read accelerometer
        //You could remove this code if you already make the accelerometer work.
        /// -[Hint] Here is a simple way to utilize the readings of accelerometer:
        ///         If x is larger than certain value (ex:0.3), then make the Pacman move right.
        ///         If x<-0.3, then make it move left. <br>


        if((tick-pre_tick)>500) { // Time step control
            pre_tick = tick; // update the previous tick
            
            
            //Move car?
            
            drive(redcar);
            drive(bluecar);
            drive(whitecar);
            /// 3. Update the Pacman on the screen
            /// -[Hint] You could update the position of Pacman (draw it on the screen) here based on the user-input at step 2. <br>
            if (!up_pb) {                                        //MOVE UP
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (y!=0) {
                    y=y-1;
                } else {
                    y=15;
                }
                wait(0.1);
                robot_init(x,y,score,end);
            } else if(!down_pb) {                                    //MOVE DOWN
                robot_clear(x,y);
                map_draw_grid(x,y);
                if(y!=15) {
                    y=y+1;
                } else {
                    y=0;
                }
                wait(0.1);
                robot_init(x,y,score,end);
            } else if (!left_pb) {                                  //MOVE LEFT
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x-=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);

            } else if(!right_pb) {                                  //MOVE RIGHT
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=16) {
                    x+=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);
            }

        }
    }*/


//////////////////////////////////////////newcode///////////////////////////////////////
robot_init(x,y, score, end);
robot_init1(a,b, score, end);
 while (1)
 {  // move = right_pb;
  
     acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
        uLCD.locate(0,0);
        uLCD.printf("sensor x%4.1f y%4.1f\n",x_,y_); //You could remove this code if you already make the accelerometer work.
  /*      if(x_>=0.3){                  //READING INPUTS FROM ACCELEROMETER
 robot_clear(x,y);
 robot_clear(x+1, y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x+=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}
else if(x_<=-0.3) {
robot_clear(x,y);
robot_clear(x+1, y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x-=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}*/


 if(y_>0.8) {
robot_clear(x,y);
robot_clear(x+1, y);
robot_clear(x+2, y);
robot_clear(x, y+1);
robot_clear(x+1, y+1);
robot_clear(x+2, y+1);
                map_draw_grid(x,y);
                if (y!=0) {
                    y=y-1;
                } else {
                    y=4;
                }
                wait(0.1);
                robot_init(x,y,score,end);                
}
else if(y_< -0.8) {
                robot_clear(x,y);
                robot_clear(x+1, y);
               robot_clear(x+2, y);
                robot_clear(x, y+1);
                robot_clear(x+1, y+1);
               robot_clear(x+2, y+1);
                map_draw_grid(x,y);
                if(y!=4) {
                    y=y+1;
                } else {
                    y=0;
                }
                wait(0.1);
                robot_init(x,y,score,end);
}

/////////////////////////////////////////////tank 2 

 if(!up_pb) {
robot_clear1(a,b);
robot_clear1(a+1, b);
//robot_clear1(a+2, b);
robot_clear1(a, b+1);
robot_clear1(a+1,b+1);
//robot_clear1(a+2,b+1);
                map_draw_grid(x,y);
                if (b!=8) {
                    b=b-1;
                } else {
                    b=12;
                }
                wait(0.1);
                robot_init1(a,b,score,end);                
}
else if(!down_pb) {
robot_clear1(a,b);
robot_clear1(a+1, b);
//robot_clear1(a+2, b);
robot_clear1(a, b+1);
robot_clear1(a+1,b+1);
//robot_clear1(a+2,b+1);
                map_draw_grid(x,y);
                if(b!=12) {
                    b=b+1;
                } else {
                    b=8;
                }
                wait(0.1);    
                robot_init1(a,b,score,end);
}

             /*else if (!left_pb) {                                  //MOVE LEFT
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x-=1;
                }
                wait(0.1);
                robot_init(x,y,score,end);

            } else if(!right_pb) {                                  //MOVE RIGHT
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=16) {
                    //x+=1;
                    uLCD.line(tank_x+10,tank_y + 5,tank_x + 15, tank_y+8 , BLACK);
                }
                wait(0.1);
                robot_init(x,y,score,end);
            }*/
        
            if (!right_pb && p <20){
                robot_shoot(x,y,p);
                p++;
                }
        }

      
        tick = timer.read_ms(); // Read current time
        if (!end){
            uLCD.locate(0,1);
          //  uLCD.printf("Score x%4.1f ",score); 
        } else {
            uLCD.locate(0,1);
            uLCD.printf("YOU WIN!!!!!");
        }
        //acc.readXYZGravity(&x,&y,&z); //read accelerometer
        //You could remove this code if you already make the accelerometer work.
        /// -[Hint] Here is a simple way to utilize the readings of accelerometer:
        ///         If x is larger than certain value (ex:0.3), then make the Pacman move right.
        ///         If x<-0.3, then make it move left. <br>


     
     }
 
     
void gameMenu(){

uLCD.background_color(RED);
   uLCD.cls();

  //   pacman_draw(x, 0);
   
    uLCD.locate(2,0);       //locate "Pocket Tanks"
    uLCD.text_height(1);
    uLCD.text_width(1);
   //  uLCD.text_underline(ON);
    uLCD.printf(" Pocket Tanks ");
    // uLCD.text_underline(OFF);
    
    uLCD.color(BLACK);                      
    uLCD.textbackground_color(RED);
    
    
    


      uLCD.locate(4,2);
 uLCD.printf("MENU");
    
    uLCD.text_height(1);
    uLCD.text_width(1);
    
    uLCD.locate(2,7);
    uLCD.printf("1. DUMMY MODE");
    
    uLCD.locate(2,9);
    uLCD.printf("2. TWO PLAYER");
    
   //   uLCD.locate(5,11);
    // uLCD.printf("3. HARD");
      
    
        uLCD.textbackground_color(BLACK);

uLCD.locate(3,14);
uLCD.color(WHITE);
    uLCD.printf("   ECE 2035   ");
    
  /*   uLCD.filled_circle(10, 120, 2, 0xFF0000);       //draw cherry
   uLCD.filled_circle(13, 121, 2, BLACK);
    uLCD.filled_circle(14, 121, 2, 0xFF0000);
    
    uLCD.pixel(10,117, 0xCCFF66);
    uLCD.pixel(11,116,0xCCFF66);
    uLCD.pixel(12,115,0xCCFF66);
     uLCD.pixel(13,114,0xCCFF66);
       uLCD.pixel(14,113,0xCCFF66);
    
    uLCD.filled_circle(14, 113, 1, 0xCCFF66);
    
    uLCD.line(14,120, 14,111,0xCCFF66); */              //end cherry
    while(1) {
        if(!up_pb|| !down_pb || !right_pb || !left_pb) {
            break;
            }
        
        }
    }