#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
uLCD_4DGL uLCD(p28, p27, p30);
#include "Robot.h"
#include "Nav_Switch.h"
#include "Speaker.h"
#include "wave_player.h"
#include "SDFileSystem.h"


BusOut mbedleds(LED1,LED2,LED3,LED4);
Robot myRobot;
Nav_Switch myNav( p21, p22, p23, p24, p25);
Mutex stdio_mutex;
AnalogOut DACout(p18); // used to play sound on speaker
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card setup


//Wiring Set-up:
//Speaker: p18
//SD Card: DO=p6,SCK=p7,DI=p5,CS=p8,VCC=Vout,GND=GND
//Thumb-Stick: U=p25,C=p24,L=p23,D=p22,R=p21,+=pVout,-=GND
bool Alive = 1;
bool Drown = 0;
bool Car = 0;
int i = 11;
int j = 11;
int C1 = 11;
int C2 = 32;
int C3 = 53;
int C4 = 74;
int C5 = 95;
int C6 = 116;
int Position1 = 90;
int Position2 = 90;
int Rate1 = 3;
    
void AutoPilot_thread(void const *argument)
{
    while(Alive) {
    //Auto-pilot Testing
    Thread::wait(500);
    stdio_mutex.lock();
    myRobot.drawEraser();
    myRobot.moveForward();
    myRobot.drawFrog();
    stdio_mutex.unlock();
    
    if(myRobot.getYPosition() == 53){   //Check dangers on Traffic 2 Row 3
            }
        if(myRobot.getYPosition() == 74){   //Check dangers on water Row 4
            if(myRobot.getXPosition() == 53 || myRobot.getXPosition() == 74 || myRobot.getXPosition() == 116){
                Alive = 0;
                Drown = 1;
                
                stdio_mutex.lock();
                myRobot.drawDrown1();
                stdio_mutex.unlock();
                Thread::wait(50);
                stdio_mutex.lock();
                myRobot.drawDrown2();
                stdio_mutex.unlock();
                Thread::wait(50);
                stdio_mutex.lock();
                myRobot.drawDrown3();
                stdio_mutex.unlock();
                Thread::wait(50);
                stdio_mutex.lock();
                myRobot.drawDrown4();
                stdio_mutex.unlock();
                Thread::wait(50);
                stdio_mutex.lock();
                myRobot.drawDrown5();
                stdio_mutex.unlock();
                }
            }
        if(myRobot.getYPosition() == 95){   //Check dangers on Traffic 1 Row 5
            }
            
    }
}

void Traffic1_thread(void const *argument) //Blue Car
{
    while(1) {
        Position1 = Position1 + Rate1;
        if(Position1 > 140 ){
            Position1 = -10;
            }
        /*stdio_mutex.lock();
        uLCD.locate(3,3);
        uLCD.printf("%5.0d", Position1);
        stdio_mutex.unlock();
        */
        
        stdio_mutex.lock();
        uLCD.filled_rectangle(Position1-10,95-4,Position1+10,95+4,BLUE);
        stdio_mutex.unlock();
        Thread::wait(30);
    }
}

void Traffic2_thread(void const *argument)  //Red Car
{
    while(1) {
        Position2 = Position2 - Rate1;
        if(Position2 < 0 ){
            Position2 = 140;
            }
        stdio_mutex.lock();
        uLCD.filled_rectangle(Position2-10,52-4,Position2+10,52+4,RED);
        stdio_mutex.unlock();
        Thread::wait(35);
    }
}

void SFX_thread(void const *argument)
{
    while(Alive){
    stdio_mutex.lock();
    uLCD.locate(1,1);
    uLCD.printf("DRY");
    stdio_mutex.unlock();
        //Thread::wait(100);
    }
    stdio_mutex.lock();
    uLCD.locate(1,1);
    uLCD.printf("SPLASH!");
    stdio_mutex.unlock();
        
    FILE *wave_file;
    wave_file=fopen("/sd/Splash.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    Thread::wait(100);
}

void Location_thread(void const *argument)
{
    while(1){
        //stdio_mutex.lock();
        //uLCD.locate(1,1);
        //uLCD.printf("%5.0d", myRobot.getXPosition());
        //uLCD.locate(8,1);
        //uLCD.printf("%5.0d", myRobot.getYPosition());
        //stdio_mutex.unlock();
    Thread::wait(10);
    }
}
void ThumbStick_thread(void const *argument)
{
    while(1) {
        mbedleds = ~(myNav & 0x0F); //update leds with nav switch direction inputs
        if(myNav.fire()) mbedleds = 0x0F; 
        
        // Player Movement checked with navigation switch
            if (myNav.left() ) 
            {            
                myRobot.moveLeft();   
            } 
            
            if (myNav.right()) 
            {             
                myRobot.moveRight();              
            }
            
            if (myNav.up()) 
            {                
                myRobot.moveForward();                
            }
            
            if (myNav.down()) 
            {
                myRobot.moveBackward();
            }
        Thread::wait(50);
    }
}

int main()
{
    //Initialize Background
    uLCD.filled_rectangle(0, 0 , 127, 127, RED); 
    myRobot.drawOutline();
    while(i <= 116){  
        while(j <= 116){    
        myRobot.drawHelper(i,j);
        j = j + 21;
        }
    j = 11;
    i = i + 21;
    }
    myRobot.drawFrog();
    
    //Thread thread1(AutoPilot_thread);
    Thread thread2(Location_thread);
    Thread thread3(ThumbStick_thread);
    Thread thread4(SFX_thread);
    Thread thread5(Traffic1_thread);
    Thread thread6(Traffic2_thread);
    
    while (1) {
        
        Thread::wait(500);
    }
}