#include "sheets.h"

sheets::sheets(Serial* RS485):
enc1(PA_6,PA_7,NC,100, QEI::X4_ENCODING),
pid(4.0, 0, 0.001, 0.01),
port_a(PB_5),
port_b(PB_4),
LimitSW1(PC_13),
LimitSW2(PB_7),
LimitSW3(PB_6)
{
    Motor = new ikarashiMDC*[2];
    Motor[0] = new ikarashiMDC(0,0,SM,RS485);
    Motor[1] = new ikarashiMDC(0,1,SM,RS485);    
    Motor[0]->braking = true;
    Motor[1]->braking = true;
    thread.start(callback(this, &sheets::loop));
    
    pid.setInputLimits(-6000, 6000);
    pid.setOutputLimits(-0.5,0.5);
    pid.setBias(0.0);
    pid.setMode(AUTO_MODE);
    pid.setSetPoint(0);
    
    port_a.write(true);
    port_b.write(false);
}

void sheets::lift()
{
    if(LimitSW1.read() == 1){
        Motor[0]->setSpeed(0);
    }else if(LimitSW1.read() == 0){
        Motor[0]->setSpeed(0.4);
    }
    Motor[1]->setSpeed(0);
    port_a.write(true);
    port_b.write(false);
}

void sheets::expansion()
{
    if(LimitSW3.read() == 1){
        Motor[1]->setSpeed(0);
    }else if(LimitSW3.read() == 0){
        Motor[1]->setSpeed(0.4);
    }
    Motor[0]->setSpeed(0);
    port_a.write(true);
    port_b.write(false);
}

void sheets::set_adjust(int height)
{
    pid.setSetPoint(height);
}   

void sheets::compute_adjust()
{
    pid.setProcessValue(RotationDistance);
    compute = pid.compute();
    Motor[0]->setSpeed(compute);
    
    Motor[1]->setSpeed(0);
    port_a.write(true);
    port_b.write(false);
}

void sheets::descent()
{
    if(LimitSW2.read() == 1){
        Motor[0]->setSpeed(0);
    }else if(LimitSW2.read() == 0){
        Motor[0]->setSpeed(-0.4);
    }
    Motor[1]->setSpeed(0);
    port_a.write(true);
    port_b.write(false);
}

void sheets::air_open()
{
    Motor[0]->setSpeed(0);
    Motor[1]->setSpeed(0);
    
    port_a.write(false);
    port_b.write(true);
}

void sheets::air_close()
{
    Motor[0]->setSpeed(0);
    Motor[1]->setSpeed(0);
    
    port_a.write(true);
    port_b.write(false);
}

void sheets::setPulse(int Loli)
{
    RotationDistance = Loli;
}

void sheets::stop()
{
    Motor[0]->setSpeed(0);
    Motor[1]->setSpeed(0);
    port_a.write(true);
    port_b.write(false);
}

void sheets::loop()
{
    while(true) {
        Limit1 = LimitSW1.read();
        Limit2 = LimitSW2.read();
        Limit3 = LimitSW3.read();
    }
}
