#ifndef PROTO01_H
#define PROTO01_H
#define PI 3.141592653589793238462643383219502884
 
#include "mbed.h"
 
/**
 * S字制御クラス
 */
class Proto1 {
public:
 
    /**
     * コンストラクタ
     * @param accdis_   加速距離
     * @param decdis_   減速距離(誤差あり。大きめに調整すると良い)
     * @param maxspeed_ 最大速度(?)
     */
    Proto1(double accdis_, double decdis_, double maxspeed_, double s_vector_);
 
    /**
     * 目標点を設定する
     * @param target_ 目標点
     * @param start_  開始地点
     */
    void target(double target_, double start_);
 
    /**
     * xy座標で目標点を設定する
     * @param targetx_ 目標点のx座標
     * @param targety_ 目標点のy座標
     * @param startx_  開始地点のx座標
     * @param starty_  開始地点のy座標
     */
    void targetXY(int targetx_, int targety_, int startx_, int starty_);
 
    /**
     * 現在地点を入力
     * @param now_ 現在地点
     */
    void Input_now(double now_);
 
    /**
     * 現在地点を入力
     * @param now_x 現在地点のx座標
     * @param now_y 現在地点のy座標
     */
    void Input_nowXY(int now_x, int now_y);
 
    /**
     * S字に変化する速度を計算
     */
    void calculate();
 
    /**
     * x方向のベクトルを返す
     */
    double getvalue_x();
 
    /**
     * y方向のベクトルを返す
     */
    double getvalue_y();
 
    /**
     * そのまま返す
     */
    double getvalue();
 
    double accdis;
    double decdis;
    double accdis2;
    double decdis2;
    double accsec;
    double decsec;
    double maxspeed;
    double maxspeed2;
 
    double s_vector;
    double vector;
 
    double startx;
    double starty;
    double start;
    double nowx;
    double nowy;
    double now;
 
    double targetDis;
    double targetRad;
    double targetx;
    double targety;
    double nowDis;
    //consdis : 一定速度で走るところ
    double consdis;
    double counter;
 
};
 
#endif