#ifndef MEASURING_WHEEL_H
#define MEASURING_WHEEL_H

#include "mbed.h"
#include "QEI.h"
#include "R1370.h"
#include "pin_config.h"
#include "SerialMultiByte.h"
#include "Dense.h"

#define FIRST_HEDDER 0xEE
#define SECOND_HEDDER 0xFF
#define BUFFER_SIZE 6

class MeasuringWheel
{
public :
    MeasuringWheel(PinName channel1_1, PinName channel1_2, PinName channel2_1, PinName channel2_2, PinName channel3_1, PinName channel3_2);

    double getOutX();
    double getOutY();
    void transmissionXY();
    double getWheel1(),getWheel2(),getWheel3();
    double getjyroAngle();
    double yaw;
private :
    static const double PIII = 3.14159265358979;
    double diameter[3];
    double distance[3];
    double radian[3];
    Eigen::Matrix3d coefficient;
    Eigen::Vector3d wheel;
    Eigen::FullPivHouseholderQR<Eigen::Matrix3d> dec;
    Eigen::Vector3d ans;
    double miniX,miniY,X,Y,subX,subY,minusX,minusY,dphi, phi;
    int loopCounter;
    void computeXY();
    void threadloop();

    QEI w1;
    QEI w2;
    QEI w3;
    SerialMultiByte serial;
    R1370 r1370;
    double Cdif, yawdegree;
    Thread thread;
    uint16_t X_, Y_,ofsetX, ofsetY, yawdegree_;
    char upBitX, upBitY, upBitAngle;
    char downBitX,downBitY, downBitAngle;
    char get;
    void resetposition();
    uint8_t txdata[BUFFER_SIZE];



};

#endif
