#include "mbed.h"
#include "hcsr04.h"

Serial pc(SERIAL_TX, SERIAL_RX);
HCSR04 usensor(D4, D6); // Trigger(DO), Echo(PWMIN)

DigitalOut led(D2);

int main()
{
    pc.printf("Start!\n\r");
    while(1) {
        usensor.start();
        unsigned int dist = usensor.get_dist_cm();
        pc.printf("cm:%ld\r\n",dist );
        
        if(dist >= 20 && dist <= 60){
            led = 1;
        }else{
            led = 0;
        }
    }
}