#ifndef CHATTERINGREMOVAL_H
#define CHATTERINGREMOVAL_H

#include"mbed.h"

/**
* @file chttaringremove.h
* @brief チャタリング防止
*
* Example :
* @code
* #include "mbed.h"
* #include "chatteringremoval.h"
*
* chatteringremoval button1(0.01);
* DigitalOut led1(LED1);
* Serial pc(USBTX,USBRX,115200);
* DigitalIn b(USER_BUTTON);
*
* int main()
* {
*     while(true) {
*         bool b_ = b;
*         button1.assignvalue(b_);
*         led1 = button1.getValue() % 2;
*         pc.printf("%d,%d",b_,button1.getCount());
*         pc.printf("\n\r");
*     }
* }
*
*
* @endcode
*/

/**
* @brief チャタリング防止用のクラス
*/
class chatteringremoval{
public:
    /**
    * @brief コンストラクタ(use_pin)
    * @param pin Pin that can do Digitalin
    * @param time chatteringtime (s)
    */
    chatteringremoval(PinName pin,float time);
    
    /**
    * @brief コンストラクタ(not_use_pin)
    * @param time chatteringtime (s)
    */
    chatteringremoval(float time);
    
    /**
    * @brief カウントの値を取得
    * @return count
    */
    unsigned int getCount();
    
    /**
    * @brief カウントのリセット
    */
    void countreset();

    /**
    * @brief データの代入
    * @param data Targetdata's value
    */
    void assignvalue(bool data);
  
    /**
    * @brief チャタリング抑制処理後の値を取得
    * @return value
    */
    bool getValue();

private:
    void threadloop();
    void valuecount();
    void checkchattering();
    DigitalIn d_in;
    //Thread thread;
    Timer t;
    unsigned int count;
    bool flag;
    bool flag_;
    bool value;
    bool _data;
    bool b;
    bool mode;
    float _time;
};

#endif