#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0);  // Pin must be on ports A or D
InterruptIn button1(PTD5);
DigitalOut led(LED_RED);
DigitalOut led5(LED_BLUE);
volatile int pressEvent =  1;
volatile int pressEvent1 = 1;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = !pressEvent ;  
}
void buttonCallback1(){
    pressEvent1 = !pressEvent1 ;  
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    button1.mode(PullUp); 
    button1.fall(&buttonCallback1) ; 
    while(true) {
        // Toggle the LED every time the button is pressed
        if (pressEvent) {
            led = !led ;
        }
        if (pressEvent1) {
            led5 = !led5 ;
            
        }
        ThisThread::sleep_for(500) ; // delay for 100ms 
    }
}