#include "mbed.h"
#include "wdt.h"


// Simple Library for Watchdog
// ---------------------------

// Initialise watchdog using 1KHz clock
//  To prevent overwriting, only a single write to the COPC register possible
//  
void wdt_1sec() {
     // 1024ms, not windowed - this is the default 
     /* SIM_COPC: COPT=11,COPCLKS=0,COPW=0 */
     SIM->COPC = (uint32_t)0x0Cu;
}

void wdt_256ms() {
     // 256ms, not windowed
     /* SIM_COPC: COPT=10,COPCLKS=0,COPW=0 */
     SIM->COPC = (uint32_t)0x08u;
}

void wdt_32ms() {
     // 32ms, not windowed  
     /* SIM_COPC: COPT=01,COPCLKS=0,COPW=0 */
     SIM->COPC = (uint32_t)0x04u;
}

// Kick (feed, reload) our watchdog timer
void wdt_kick_all(){
    SIM->SRVCOP = (uint32_t)0x55u;
    SIM->SRVCOP = (uint32_t)0xAAu;
}

void wdt_kickA(){
    SIM->SRVCOP = (uint32_t)0x55u;
}

void wdt_kickB(){
    SIM->SRVCOP = (uint32_t)0xAAu;
}


