#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut blueLED(D5);   // first LED
DigitalOut greenLED(D6);   // second LED
DigitalOut yellowLED(D7); // third led
DigitalOut redLED(D8);    // fourth led
TSISensor tsi;

Thread redThread ; // thread for red LED
Thread greenThread ; // thread for green LED
Thread blueThread ; // thread for blue LED
Thread yellowThread ; // thread for yellow LED

# define BLUEFLAG 0x01
# define GREENFLAG 0x02
# define YELLOWFLAG 0x04
# define REDFLAG 0x08

EventFlags signals;  // event flags for signalling; 2 used

void blue_thread()    // method to run in thread
{
    while (true) {
        signals.wait_any(BLUEFLAG); // wait for signal
        blueLED = !blueLED ;  // toggle
        ThisThread::sleep_for(1000) ; // wait(1.0);
        signals.clear(BLUEFLAG) ;
        // Signal are automatically cleared by wait_any but
        // the signal might have been set again while LED on
    }
}

void green_thread()    // method to run in thread
{
    while (true) {
        signals.wait_any(GREENFLAG);
        greenLED = !greenLED ; // toggle
        ThisThread::sleep_for(1000) ; // wait(1.0);
        signals.clear(GREENFLAG) ;
        // Signal are automatically cleared by wait_any but
        // the signal might have been set again while LED on
    }
}
void yellow_thread()    // method to run in thread
{
    while (true) {
        signals.wait_any(YELLOWFLAG);
        yellowLED = !yellowLED ; // toggle
        ThisThread::sleep_for(1000) ; // wait(1.0);
        signals.clear(YELLOWFLAG) ;
        // Signal are automatically cleared by wait_any but
        // the signal might have been set again while LED on
    }
}
void red_thread()    // method to run in thread
{
    while (true) {
        signals.wait_any(REDFLAG);
        redLED = !redLED ; // toggle
        ThisThread::sleep_for(1000) ; // wait(1.0);
        signals.clear(REDFLAG) ;
        // Signal are automatically cleared by wait_any but
        // the signal might have been set again while LED on
    }
}


int main(void)
{
    redLED = 0 ; // turn off
    greenLED = 0 ; // turn off
    blueLED = 0 ;
    yellowLED = 0;
    redThread.start(red_thread) ; // start the red thread
    greenThread.start(green_thread) ; // start the green thread
    blueThread.start(blue_thread) ;  // start the blue thread
    yellowThread.start(yellow_thread) ;  // start the yellow thread

    enum state {None, outerleft, innerleft, innerright, outerright};
    int state = None;
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
        // When no touch --> 0
        // Left --> low value  Right --> high value
        pc.printf("%d", d) ;
        pc.putc(' ') ;


        switch(state) {
            case None:
                if (d > 3 && d < 9) {
                    signals.set(BLUEFLAG);  // if the tsi value is within 3 and 9, set the blue flag, which turns on the blue led, the flag is mentioned within the led thread, that controls the on and off procedure.
                    state = outerleft;
                }
                if (d > 13 && d < 19) {
                    signals.set(GREENFLAG);  // if the tsi value is within 13 and 19, set the green flag, which turns on the green led.
                    state = innerleft;
                }
                if (d > 23 && d < 29) {
                    signals.set(YELLOWFLAG);  // if the tsi value is within 23 and 29, set the yellow flag, which turns on the yellow led.
                    state = innerright;
                }
                if (d > 33) {
                    signals.set(REDFLAG);  // if the tsi value is more then 33, set the red flag, which turns on the red led.
                    state = outerright;
                }
                break;

            case innerright:
                if(d < 3 || d > 9) state = None; // if the tsi value is outside of 3 and 9, go to state none.
                break;
            case innerleft:
                if(d < 13 || d > 19) state = None;  // if the tsi value is outside of 13 and 19, go to state none.
                break;
            case outerleft:
                if(d < 23 || d > 29)state = None;  // if the tsi value is outside of 23 and 29, go to state none.
                break;
            case outerright:
                if (d < 33)state = None;  // if the tsi value is less then 33 go to state none.
                break ;

                ThisThread::sleep_for(1000) ; // This polling rate is too slow - increase it
                // The slower rate maks it easier to output on the terminal
        }
    }
}
