#include "mbed.h"

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);


bool clock_set = 0;
time_t read_time = 0;
time_t seconds;

int main() {

    pc.baud(9600);

    while (1) {

        // have we set our clock yet?
        if (clock_set == 0) {
            // try to request the time
            pc.printf("epoch\n\r");
            // wait a bit
            wait(0.1);
            // try to read a long int
            if (pc.readable()) {
                scanf("%d",&read_time);
                if (read_time > 0) {
                    // set the time
                    pc.printf("time value read: %u\r\n",read_time);
                    set_time(read_time);
                    wait(0.2);
                    clock_set = 1;
                } else {
                    // delay longer and try again
                    wait(4);
                }
            } else{
                wait (0.1);
            }            
        } else {
            // display time
             //seconds = time(NULL);
             //struct tm *t = localtime(&seconds);
             //pc.printf("%04d-%02d-%02d %02d:%02d:%02d UTC\r\n",(t->tm_year+1900),(t->tm_mon+1),t->tm_mday,t->tm_hour,t->tm_min,t->tm_sec);
             // delay 5 seconds
             //wait(1);
             ;;
        }
        
        myled = !myled;
        //wait(0.2);
        //pc.printf("Hello World\r\n");
        
        seconds = time(NULL);
        struct tm *t = localtime(&seconds);
        pc.printf("%04d-%02d-%02d %02d:%02d:%02d UTC\r\n",(t->tm_year+1900),(t->tm_mon+1),t->tm_mday,t->tm_hour,t->tm_min,t->tm_sec);
        wait(1);

            
    }

}


