#include "mbed.h"
#include "Library/OmniMove/OmniMove.h"
#include "Library/SerialCtrl_OS6/SerialCtrl.h"

#define CAN_FREQUENCY 900000
#define ENCODER_NEUTRAL 32767
#define ONEROUND_PLUSE (2048 * 4)
#define CAN_FOR 4
#define MAX_SPEED 1
#define M_PI 3.141592
#define ODOMETR_QUA 2
#define dt 0.01 //s (10ms)
#define dv 0.005  //台形制御に使用する delta velocity

// Instance
CAN can(PA_11, PA_12, CAN_FREQUENCY);   //RD,TDの順で書く
CANMessage msg; //パケットのようなものでデータをひとまとめにして送信する
OmniMove omni;  //オムニ

//Serial
BufferedSerial FEP(PC_10, PC_11, 38400);  //シリアル通信のピン宣言
Timer checker;                          //タイマーの宣言
SerialCtrl wire(&FEP, &checker);        //シリアル通信のライブラリ宣言

// PIN
AnalogIn volume(PC_4);
DigitalOut  dbug1(PB_5),
            dbug2(PB_10),
            dbug3(PA_8);

DigitalOut digi[5]{
    DigitalOut(PB_15),
    DigitalOut(PB_14),
    DigitalOut(PB_13),
    DigitalOut(PB_1),
    DigitalOut(PB_9)};

PwmOut pwm[5] {
    PwmOut(PB_8),
    PwmOut(PC_6),
    PwmOut(PB_2),
    PwmOut(PB_5),
    PwmOut(PC_9)};

// Prototype
bool can_send(int can_id);
void scheproces();
void motor_controller(int id, float speed);

// Global variable
unsigned char data[8] = {0,0,0,0,0,0,0,0}; //シリアルで受け取った情報を格納する変数
double X, Y, speed=0, theta=0, angle=0, cur_speed[4] = {0, 0, 0, 0};
float motor_output[4] = {0,0,0,0};

//メイン関数
int main() {
  int fail = 0, i;
  bool can_alive;
  float EncAng[ODOMETR_QUA] = {0, 270}, EncR[ODOMETR_QUA] = {25.4,25.4}, EncPos[ODOMETR_QUA]= {100,100};

  for (int i=0; i<4; i++) 
    pwm[i].period_us(83);
  
  //initialize
  checker.reset();          // timer reset
  checker.start();          // timer start
  wire.param(0xAF, 0xED);   // header and footer
  omni.setup(4, 45);        // ベクトル計算ライブラリ

  while( true ) {
    // Serial通信が成功すれば実行
    if ( wire.get() ) {
      fail = 0;   // fail reset

      X = 2*((double)wire.data[LX] / 255)-1;
      Y = 2*(( 255 - (double)wire.data[LY]) / 255)-1;
      X = (abs(X) > 0.05)? X : 0;
      Y = (abs(Y) > 0.05)? Y : 0;

      speed = sqrt(X*X + Y*Y);
      speed = (speed > 1)? MAX_SPEED : speed * MAX_SPEED;
      theta = atan2(Y, X) * 180 / M_PI;

      omni.input_polar(speed, theta, 0, 0.5); //マシンの走行速度、進行方向、回転速度、回転と直交の比率を入力
      omni.output( motor_output );

      // 台形制御
      for (int i=0; i<4; i++) {
        
        if ( (motor_output[i] - cur_speed[i]) > 0 )
          cur_speed[i] += dv; // 正回転の場合
        else 
          cur_speed[i] -= dv; // 負回転の場合
        
        motor_controller(i, cur_speed[i]);

        // printf("%d ", (int)((motor_output[i] - cur_speed[i])*100));
      }
      printf("\n");
    
    } else {
      fail ++;
      if (fail > 5) {}
    }
  }

  return 0;
}

bool can_send(int can_id) {
  msg.data[0] = can_id;
  msg.data[1] = data[can_id];

  return can.write(msg);  //データを送信する（送信失敗でval=0、成功で1）
}

void motor_controller(int id, float speed) {
  
  // 2番、3番モーターは逆回転
  if ( id == 2 || id == 3 )
    speed *= -1;

  if ( fabs(speed) < 0.05 ) {
    digi[id] = 0;
    pwm[id] = 0;
  } else if ( speed > 0) {
    digi[id] = 0;
    pwm[id] = speed;
  } else {
    digi[id] = 1;
    pwm[id] = speed + 1;
  }
}
