#ifndef MBED_DRA818_H
#define MBED_DRA818_H
 
#include "mbed.h"

class DRA818 {
    public:
        DRA818(Serial *s, PinName PTT);
        void setTXFreq(double tx_freq);
        void setRXFreq(double rx_freq);
        void setTXCTCSS(uint8_t tx_ctcss);
        void setRXCTCSS(uint8_t rx_ctcss);
        void setSquelch(uint8_t sql);
        void setVolume(uint8_t vol);
        void setGWB(bool gwb);
        void setFilters(bool preemph, bool highpass, bool lowpass);
        void writeFreq();

    private:
        Serial *serial;
        DigitalOut PTT_PIN;
        uint8_t tx_ctcss;
        uint8_t rx_ctcss;
        float tx_freq;
        float rx_freq;
        bool gwb;
        uint8_t volume;
        uint8_t squelch;
        uint8_t preemph;
        uint8_t highpass;
        uint8_t lowpass;
        char buffer[60];
};
#endif        