#include "mbed.h"
#include "dra818.h"

DRA818::DRA818(Serial *s, PinName PTT): PTT_PIN(PTT){
    this->serial = s;
    this->PTT_PIN=1;
   
    this->tx_ctcss = 0;
    this->rx_ctcss = 0;
    this->tx_freq =  146.500;

    this->volume = 4;
    this->squelch = 0;
    this->preemph = 0;
    this->highpass = 0;
    this->lowpass = 0;
}


void DRA818::setTXFreq(double tx_freq){
    if( (tx_freq>136.000 && tx_freq<174.000 ) || (tx_freq>410.000 && tx_freq<480.000) ){
        this->tx_freq = tx_freq;
    }
}

void DRA818::setRXFreq(double rx_freq){
    if( (rx_freq>136.000 && rx_freq<174.000 ) || (rx_freq>410.000 && rx_freq<480.000) ){
        this->rx_freq = rx_freq;
    }
}

// Refer to https://en.wikipedia.org/wiki/CTCSS for CTCSS values.
void DRA818::setTXCTCSS(uint8_t ctcss){
    if(ctcss<=38){
        this->tx_ctcss = ctcss;
    }
}
void DRA818::setRXCTCSS(uint8_t ctcss){
    if(ctcss<=38){
        this->rx_ctcss = ctcss;
    }
}

void DRA818::setGWB(bool gwb){
    this->gwb=gwb?1:0;
}

void DRA818::setSquelch(uint8_t sql){
    if(sql<=8){
        this->squelch = sql;
    }
}

void DRA818::writeFreq(){
    this->PTT_PIN=1;
    wait_ms(500); // Delay for a bit, to let the uC boot up (?)

    char tx_freq_buffer[10];
    char rx_freq_buffer[10];

    sprintf(tx_freq_buffer,"%.4f",this->tx_freq);
    sprintf(rx_freq_buffer,"%.4f",this->rx_freq);
    sprintf(this->buffer,"AT+DMOSETGROUP=%d,%s,%s,%04d,%1d,%04d\r\n",this->gwb,tx_freq_buffer,rx_freq_buffer,this->tx_ctcss,this->squelch,this->rx_ctcss);
    this->serial->printf("%s",this->buffer);
}

void DRA818::setVolume(uint8_t vol){
    if(vol>=1 || vol<=8){
        this->volume = vol;
    }

    this->PTT_PIN=1;
    wait_ms(500); // Delay for a bit, to let the uC boot up (?)

    sprintf(this->buffer,"AT+DMOSETVOLUME=%1d\r\n",this->volume);
    this->serial->printf("%s",this->buffer);
}

void DRA818::setFilters(bool preemph, bool highpass, bool lowpass){
    this->preemph=preemph?1:0;
    this->highpass=highpass?1:0;
    this->lowpass=lowpass?1:0;

    this->PTT_PIN=1;
    wait_ms(500); // Delay for a bit, to let the uC boot up (?)

    sprintf(this->buffer,"AT+SETFILTER=%1d,%1d,%1d\r\n",this->preemph,this->highpass,this->lowpass);
    this->serial->printf("%s",this->buffer);
}