#include "mbed.h"
#include "servo_ppm.h"

#define JOYSTICK_ID_L 0x0cfdd633
#define JOYSTICK_ID_R 0x0cfdd634
#define CAN_TD D2
#define CAN_RD D10
#define PPM_PIN A6

//CANBus                                               
CAN can(CAN_RD, CAN_TD);

//**FOR SERIAL OUTPUT USING PUTTY                 using 64-bit avaialble from https://www.chiark.greenend.org.uk/~sgtatham/putty/latest.html                                             
Serial pc(SERIAL_TX, SERIAL_RX);  

//PPM Output
servo_ppm ppm(PPM_PIN);
    
    //Function to read the CANbus and decode the data
    void readCAN(void) {
        CANMessage msg;
        if(can.read(msg)) {
            
            pc.printf("\r\n msg id %d check %d %d \r\n", (int)msg.id, JOYSTICK_ID_L, JOYSTICK_ID_R); 
            
            if((int)msg.id == JOYSTICK_ID_L) {
                
                int rightStatus = (int)(msg.data[0]>>4)%4;
                int leftStatus = (int)(msg.data[0]>>2)%4;
                int centerXStatus = (int)msg.data[0]%4;     
                int xAxisRaw = (int)(msg.data[0]>>6) + (msg.data[1]<<2);
                int xl = 1500;
                if(rightStatus > 0) xl += (xAxisRaw / 2);
                if(leftStatus > 0) xl -= (xAxisRaw / 2);
                if(xl > 2000) xl = 2000;
                if(xl < 1000) xl = 1000;
                               
                int forwardStatus = (int)(msg.data[2]>>4)%4;
                int backwardStatus = (int)(msg.data[2]>>2)%4;
                int centerYStatus = (int)msg.data[2]%4;             
                int yAxisRaw = (int)(msg.data[2]>>6) + (msg.data[3]<<2);
                int yl = 1500;
                if(forwardStatus > 0) yl += (yAxisRaw / 2);
                if(backwardStatus > 0) yl -= (yAxisRaw / 2);
                if(yl > 2000) yl = 2000;
                if(yl < 1000) yl = 1000;
                
                //note button 1 = top left, button 2 = top right
                int button1 = (int)(msg.data[5]>>6)%4;
                int button2 = (int)(msg.data[5]>>4)%4;
                int tl = 1500;
                if(button2 > 0) tl += 500;
                if(button1 > 0) tl -= 500;
                
                //front button
                int button8 = (int)msg.data[6]%4;
                int fl = 1000;
                if(button8 > 0) fl += 1000;
                
                ppm.setServoPulseDuration_us(3, yl);
                ppm.setServoPulseDuration_us(4, xl);
                ppm.setServoPulseDuration_us(5, fl);
                ppm.setServoPulseDuration_us(7, tl);
                
                
            } else if((int)msg.id == JOYSTICK_ID_R) {
                
                int rightStatus = (int)(msg.data[0]>>4)%4;
                int leftStatus = (int)(msg.data[0]>>2)%4;
                int centerXStatus = (int)msg.data[0]%4;     
                int xAxisRaw = (int)(msg.data[0]>>6) + (msg.data[1]<<2);
                int xr = 1500;
                if(rightStatus > 0) xr += (xAxisRaw / 2);
                if(leftStatus > 0) xr -= (xAxisRaw / 2);
                if(xr > 2000) xr = 2000;
                if(xr < 1000) xr = 1000;
                               
                int forwardStatus = (int)(msg.data[2]>>4)%4;
                int backwardStatus = (int)(msg.data[2]>>2)%4;
                int centerYStatus = (int)msg.data[2]%4;             
                int yAxisRaw = (int)(msg.data[2]>>6) + (msg.data[3]<<2);
                int yr = 1500;
                if(forwardStatus > 0) yr += (yAxisRaw / 2);
                if(backwardStatus > 0) yr -= (yAxisRaw / 2);
                if(yr > 2000) yr = 2000;
                if(yr < 1000) yr = 1000;
                
                //note button 1 = top left, button 2 = top right
                int button1 = (int)(msg.data[5]>>6)%4;
                int button2 = (int)(msg.data[5]>>4)%4;
                int tr = 1500;
                if(button2 > 0) tr += 500;
                if(button1 > 0) tr -= 500;
                
                //front button
                int button8 = (int)msg.data[6]%4; 
                int fr = 1000;
                if(button8 > 0) fr += 1000;
                 
                ppm.setServoPulseDuration_us(1, xr);
                ppm.setServoPulseDuration_us(2, yr);
                ppm.setServoPulseDuration_us(6, fr);
                ppm.setServoPulseDuration_us(8, tr);                    
            }                       
        }   
    }
    
int main() {
    pc.baud(115200);     
    pc.printf("\r\n Starting CANBus Joystick to ESC PWM \r\n"); 
                
    //right stick
    ppm.setServoPulseDuration_us(1, 1500);
    ppm.setServoPulseDuration_us(2, 1500);
    //left stick
    ppm.setServoPulseDuration_us(3, 1500);
    ppm.setServoPulseDuration_us(4, 1500);
    //front buttons   
    ppm.setServoPulseDuration_us(5, 1000);
    ppm.setServoPulseDuration_us(6, 1000);
    //top buttons
    ppm.setServoPulseDuration_us(7, 1500);
    ppm.setServoPulseDuration_us(8, 1500);
    
    //start ppm
    ppm.startServoPpmOutput();

    //CANBus @250kb/s
    can.frequency(250000);
   // can.filter(0x70,0x70,CANExtended); //CANbus filtering to only accept 0x70

    wait(1.0);

    while(true) {
        pc.printf("alive\r\n");
        readCAN();      //read Joystick CANBus and adjust duty
        
        wait(0.01);
        
        //pc.printf("R: %d, L: %d\r\n", rightDuty, leftDuty);
        //wait(1);
    }
    
}

                                   

    