#include "mbed.h"
#include <pjon.h>
/*
// network(Arduino pin used, selected device id)
PJON network(p12, 1);
DigitalOut myled(LED1);

int main() {
    network.send(44, "B", 1, 1000000);
    while(1) {
        network.update();
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
*/

float test;
float mistakes;
int busy;
int fail;

// network(Arduino pin used, selected device id)
PJON network(p21, 45);
Serial serial(USBTX, USBRX);
Timer timer;
int packet;
char content[] = "01234567890123456789";

void setup() {
  serial.baud(19200);
  timer.start();
  serial.printf("PJON - Network analysis\n\r");
  serial.printf("Starting a 10 seconds communication test..\n\r\n\r");
}

void loop() {
  Timer t2;
  long time = timer.read_ms();
  while(timer.read_ms() - time < 10000) {
 
    /*
    Here send_string low level function is used to
    be able to catch every single sending result. 
    */
 
    int response = network.send_string(44, content, 20);
    if(response == ACK)
      test++;
    if(response == NAK)
      mistakes++;
    if(response == BUSY)
      busy++;
    if(response == FAIL)
      fail++;
    wait_us(50);
  }
  
  serial.printf("Absolute com speed: ");
  serial.printf("%i", (test * 24 ) / 10 );
  serial.printf("B/s\n\r");
  serial.printf("Practical bandwidth: ");
  serial.printf("%i", (test * 20 ) / 10 );
  serial.printf("B/s\n\r");
  serial.printf("Packets sent: ");
  serial.printf("%f\n\r", test);
  serial.printf("Mistakes (error found with CRC) ");
  serial.printf("%f\n\r", mistakes);
  serial.printf("Fail (no answer from receiver) ");
  serial.printf("%i\n\r", fail);
  serial.printf("Busy (Channel is busy or affected by interference) ");
  serial.printf("%i\n\r", busy);
  serial.printf("Accuracy: ");
  serial.printf("%i", 100 - (100 / (test / mistakes)));
  serial.printf(" %\n\r");
  serial.printf(" --------------------- \n\r");
  
  test = 0; 
  mistakes = 0;
  busy = 0;
  fail = 0;
};

int main(){
    setup();
    while(true){
        loop();
    }   
}