/**
<Copyright Header>
Copyright (c) 2013 Jordan "Earlz" Earls  <http://Earlz.net>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
</Copyright Header>
**/

#include "lightvm.h"

void op16_single_arg(lightvm_state* s, uint16_t op, uint16_t* arg2)
{
    unsigned int secondary=op & 0xF000 >> 12;
    switch(secondary)
    {
        case 0:
        //push
        lightvm_push(s, *arg2);
        break;
        case 1:
        //pop
        *arg2 = lightvm_pop(s);
        break;
        case 2:
        //not
        *arg2 = ~(*arg2);
        break;
        case 3:
        //unused
        case 4:
        //unused
        case 5:
        //unused
        case 6:
        //xcall?
        case 7:
        //and.eq
        *s->tr &= *s->cr == *arg2;
        break;
        case 8:
        //or.eq
        *s->tr |= *s->cr == *arg2;
        break;
        case 9:
        //and.neq
        *s->tr &= *s->cr != *arg2;
        break;
        case 10:
        //or.neq
        *s->tr |= *s->cr != *arg2;
        break;
        case 11:
        //set TR
        *s->tr = 1;
        break;
        case 12:
        //reset TR
        *s->tr = 0;
        break;
        case 13:
        //load CR
        *s->cr = *arg2;
        break;
        case 14:
        //8.bank PROBABLY NOT
        case 15:
        //unused
        default:
        return;
    }
    return;
}

