/*
<Copyright Header>
Copyright (c) 2012 Jordan "Earlz" Earls  <http://lastyearswishes.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file is part of the MbedConsole project
*/

#include "mbedconsole.h"
#include "clock.h"
#include "i2s.h"
#include "nvic.h"
#include "SDFileSystem.h" 

#define DEVICE_STDIO_MESSAGES
#include "mbed_debug.h"
 
PS2Keyboard *ps2kb;
DigitalOut myled(LED1);
Serial serial(USBTX, USBRX);
ConsoleStream console("console");
SDFileSystem *sdcard;


void keyboard_init();

int main() {
    serial.baud(9600);
    serial.puts("Resetting interrupt priorities..\n");
    //Set all priorities to 100 so we are able to make VGA a priority
    //By default, all priorities are at their highest 0
    NVIC_SetPriority( NonMaskableInt_IRQn, 100 ); 
    NVIC_SetPriority(MemoryManagement_IRQn, 100);
    
    NVIC_SetPriority(BusFault_IRQn, 100);
    NVIC_SetPriority(UsageFault_IRQn, 100);
    NVIC_SetPriority(SVCall_IRQn, 100);
    NVIC_SetPriority(DebugMonitor_IRQn, 100);
    NVIC_SetPriority(PendSV_IRQn, 100);
    NVIC_SetPriority(SysTick_IRQn, 50);
    NVIC_SetPriority(WDT_IRQn, 100);
    NVIC_SetPriority(TIMER0_IRQn, 85);
    NVIC_SetPriority(TIMER1_IRQn, 85);
    NVIC_SetPriority(TIMER2_IRQn, 85);
    NVIC_SetPriority(TIMER3_IRQn, 85);
    NVIC_SetPriority(UART0_IRQn, 75);
    NVIC_SetPriority(UART1_IRQn, 100);
    NVIC_SetPriority(UART2_IRQn, 100);
    NVIC_SetPriority(UART3_IRQn, 100);
    
    NVIC_SetPriority(PWM1_IRQn, 100);
    NVIC_SetPriority(I2C0_IRQn, 100);
    NVIC_SetPriority(I2C1_IRQn, 100);
    NVIC_SetPriority(I2C2_IRQn, 100);
    NVIC_SetPriority(SPI_IRQn, 1);
    NVIC_SetPriority(SSP0_IRQn, 100);
    NVIC_SetPriority(SSP1_IRQn, 100);
    NVIC_SetPriority(PLL0_IRQn, 100);
    NVIC_SetPriority(RTC_IRQn, 100);
    NVIC_SetPriority(EINT0_IRQn, 100);
    NVIC_SetPriority(EINT1_IRQn, 100);
    
    NVIC_SetPriority(EINT2_IRQn, 100);
    NVIC_SetPriority(EINT3_IRQn, 100);
    NVIC_SetPriority(ADC_IRQn, 100);
    NVIC_SetPriority(BOD_IRQn, 100);
    NVIC_SetPriority(USB_IRQn, 100);
    NVIC_SetPriority(CAN_IRQn, 100);
    NVIC_SetPriority(DMA_IRQn, 100);
    
    NVIC_SetPriority(I2S_IRQn, 100);
    NVIC_SetPriority(ENET_IRQn, 100);
    NVIC_SetPriority(RIT_IRQn, 100);
    NVIC_SetPriority(MCPWM_IRQn, 100);
    NVIC_SetPriority(QEI_IRQn, 100);
    NVIC_SetPriority(PLL1_IRQn, 100);
    init_vga();
    vga_cls();
    keyboard_init();
    fl_select_clock_i2s(FL_CLOCK_DIV1); // assume 100MHz
    fl_i2s_set_tx_rate(1,4);            // set 25 MHz pixel clock 

    
    NVIC_SetPriority( EINT3_IRQn, 90 ); 
    
    //initialize way down here AFTER overclocking has already taken place
    //Otherwise we end up with sdcard assume a different clockrate or something
    wait(0.5); //MAGIC do not remove this wait statement. SD card won't work otherwise.
    sdcard=new SDFileSystem(p11, p12, p13, p20, "sd");
    
    freopen("/console", "w", stdout);
    setvbuf(stdout, NULL, _IONBF, 0);
    freopen("/console", "r", stdin);
    setvbuf(stdout, NULL, _IONBF, 0);
    //freopen("/console", "w", stderr);
    setvbuf(stderr, NULL, _IONBF, 0);
    //serial.baud(9216);//9600);
    
    serial.puts("Entering main shell\n");
    debug("testing... ");
    while(1)
    {
        vputs("mbedConsole by Jordan Earls\n");
        shell_begin();
    }
}




