/*
<Copyright Header>
Copyright (c) 2012 Jordan "Earlz" Earls  <http://lastyearswishes.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file is part of the MbedConsole project
*/

#include "mbedconsole.h"
#include "plEarlz.h"
#include "PS2Keyboard.h"

#include "SDFileSystem.h"

char kbd_GetKey();

LocalFileSystem local("local");

/*
void do_hackaday()
{
   // int y=150;
    int tmp=0;
    for(int y=0;y<HACKADAY_HEIGHT;y++)
    {
        for(int x=0;x<HACKADAY_WIDTH;x++)
        {
            int byte=tmp/8;
            int bit=tmp%8;
            bit=bit-7; //bits are reversed! Those bastards!
            bit=-bit;
            vga_plot(x,y, (hackadaylogo[byte]&(1<<bit))==0);
            tmp++;
        }
    }
}
*/
void shell_begin(){
    //do_hackaday();
    vputs(">>Micro eMBEDded Shell v0.1<<\n");
    char *cmd=(char*)malloc(128);
    bool valid=false;
    while(1){
        vputs("> ");
        vgetsl(cmd, 128);
        vputc('\n');
        valid=false;
        if(strlcmp(cmd, "help", 5)==0){
            valid=true;
            vputs("Command list:\n");
            vputs("help     -- this text \n");
            vputs("cls      -- clear the screen\n");
            vputs("testX    -- test (where X is number) performs tests\n");
            vputs("reboot   -- resets the processor\n");
            vputs("about    -- prints text about how we got to here\n");
            vputs("plearlz  -- enter the PLEarlz Forth shell\n");
        }else if(strlcmp(cmd,"cls",4)==0){
            valid=true;
            vga_cls();
            vsetcursor(0,0);
        }else if(strlcmp(cmd,"test", 5)==0){
            valid=true;
            vputs("Opening File...Screen may flicker!\n"); // Drive should be marked as removed
            wait(5);
            FILE *fp = fopen("/local/test.txt", "w");
            if(!fp) {
                vputs("File /local/test.txt could not be opened!\n");
                exit(1);
            }
            
            wait(5.0);
            
            vputs("Writing Data...\n");    
            fprintf(fp, "Hello World!");
            
            wait(5.0);
        
            vputs("Closing File...\n");
            fclose(fp);
        
                // Drive should be restored. this is the same as just returning from main
            wait(5);
        }else if(strlcmp(cmd, "test2", 6)==0){
            while(1){
                vputc(kbd_GetKey());
            }
        }else if(strlcmp(cmd, "test3", 6) == 0)
        {
            //SDFileSystem sdcard(p11, p12, p13, p20, "sd");
            FILE *fp = fopen("/sd/sdtest.txt", "w");
            if(fp == NULL) {
                vputs("Could not open file for write\n");
            }
            fprintf(fp, "Hello fun SD Card World!");
            fclose(fp); 
        }else if(strlcmp(cmd, "format", 7) == 0)
        {
            if(sdcard->format()!=0)
            {
                vputs("Error formatting :(");
            }
        }else if(strlcmp(cmd, "plearlz", 8)==0){
            valid=1;
            pl_shell();
        }else if(strlcmp(cmd,"reboot", 7)==0){
            valid=1;
            NVIC_SystemReset();
        }else if(strlcmp(cmd, "about", 6)==0){
            valid=1;
            vputs("I am Jack's broken monolog\n");
        }else if(strlcmp(cmd, "scheme", 7)==0){
            valid=1;
            //scheme_main();
        }
        if(!valid){
            vputs("Invalid Command! Try `help` if you need it\n");
        }
    }
}



