/*
<Copyright Header>
Copyright (c) 2012 Jordan "Earlz" Earls  <http://lastyearswishes.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file is part of the MbedConsole project
*/

#include "mbedconsole.h"
#include "keyboard.h"

#define FONTHEIGHT 16
#define FONTWIDTH 8

int console_x=0, console_y=(250/15);
int console_color=WHITE; //text color


void vsetcursor(int x, int y)
{
    console_x=x;
    console_y=y;
}

void vrawputc(char c)
{
    //fuck that shitv
    if(console_x>80)
    {
        return;
    }
    //shift left for fast multiply
    vga_putchar(console_x<<3, console_y<<4, c, console_color);
}
void vputc(char c)
{
    //shift left for fast multiply
    if(console_x>=79)
    {
        console_x=0;
        console_y++;
    }
    if(console_y>=29)
    {
        console_y--;
        vga_scroll();
    }
    switch(c){
        case '\n':
        case '\r':
        console_y++;
        console_x=0;
        break;
        case '\b':
        vrawputc(' ');
        if(console_x>0)
        {
            console_x--;
        }
        vrawputc(' ');
        break;
        case '\t':
        for(int i=0;i<4;i++)
        {
            console_x++;
            vrawputc(' ');
        }
        default:
        vga_putchar(console_x<<3, console_y<<4, c, console_color);
        console_x++;
    }
}

void vputs(char *s){
    while(*s!=0){
        vputc(*s);
        s++;
    }
}

char vgetc()
{
    char tmp=kbd_GetKey();
    vputc(tmp);
    return tmp;
}
int vgetsl(char *buf, int len)
{
    int pos=0;
    while(1){
        buf[pos]=kbd_GetKey();
        if(buf[pos]=='\r'){
            buf[pos]='\n';
        }
        
        vputc(buf[pos]);
        if(buf[pos]=='\b'){
            buf[pos]=0;
            if(pos>0){
                pos--;
                buf[pos--]=0;
            }
        }
        if(pos>len-1){
            break;
        }
        if(buf[pos]=='\n'){
            buf[pos]=0;
            return 1;
        }
        pos++;
    }
    return 0;
}



int strlcmp(const char *s1,const char *s2,size_t count){
    int i=0;
    while((s1[i]!=0) && (s2[i]!=0)){
        if(s1[i]!=s2[i]){
            return -1;
        }
        if(i>=count){
            return -1;
        }
        i++;
        
    }
    if(s1[i]!=s2[i]){
        return -1;
    }
    return 0;
}

