/*
<Copyright Header>
Copyright (c) 2012 Jordan "Earlz" Earls  <http://lastyearswishes.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file is part of the MbedConsole project
*/

#ifndef MBEDCONSOLE_H
#define MBEDCONSOLE_H

#include "mbed.h"
#include "vga640x480g.h"
#include "PS2Keyboard.h"
#include "SDFileSystem.h"

void vputc(char c);
void vputs(char *s);
char vgetc();
int vgetsl(char *s, int len);
void vsetcursor(int x, int y);

int strlcmp(const char *s1,const char *s2,size_t count);

void shell_begin();

extern PS2Keyboard *ps2kb;

extern SDFileSystem *sdcard;

extern Serial serial;


class ConsoleStream : public Stream //do this so we get printf and other goodies. Uses C functions for VGA and PS/2
{
    public:
    ConsoleStream(const char* name):Stream(name){}
    protected:
 
    // Stream implementation functions
    virtual int _putc(int value)
    {
        vputc((char)value);
        return 1;
    }
    virtual int _getc()
    {
        return vgetc();
    }
};

extern ConsoleStream console;


//Byte array of bitmap of 464 x 240 px:

#define HACKADAY_WIDTH 464
#define HACKADAY_HEIGHT 240

extern "C" const uint8_t hackadaylogo[];


#endif