/*
<Copyright Header>
Copyright (c) 2012 Jordan "Earlz" Earls  <http://lastyearswishes.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file is part of the MbedConsole project
*/

#include "mbedconsole.h"
#include "plEarlz.h"
#include <stdint.h>
#include <stdarg.h>


//An extremely simple virtual machine to make this implementation about 10 times easier and probably a bit faster





int pl_stackpos=0;
int pl_stack[MAXSTACK];




int pl_dictionary_count=0;
int pl_dictionary_size=0;
WordKey *pl_dictionary; //todo: a hash table would be much faster

void pl_push(int val)
{
    if(pl_stackpos>=MAXSTACK)
    {
        vputs("Stack overflow!");
        pl_error=StackOverflow;
        return;
    }
    pl_stack[pl_stackpos]=val;
    pl_stackpos++;
}
int pl_pop()
{
    if(pl_stackpos<=0)
    {
        vputs("Stack underflow!");
        pl_error=StackUnderflow;
        return 0;
    }
    pl_stackpos--;
    return pl_stack[pl_stackpos];
}

WordKey *pl_lookup(char* name)
{
    for(int i=0;i<pl_dictionary_count;i++)
    {
        if(strlcmp(name, pl_dictionary[i].name, 12)==0)
        {
            return &pl_dictionary[i];
        }
    }
    return NULL;
}

int pl_addword()
{
    if(pl_dictionary_size==0){
        pl_dictionary=(WordKey*)malloc(sizeof(WordKey)*12);
        pl_dictionary_size=12;
        return 0;
    }
    if(pl_dictionary_size<=pl_dictionary_count)
    {
        void* tmp=realloc(pl_dictionary, pl_dictionary_size+sizeof(WordKey)*DICTIONARYSTEP);
        if(tmp==NULL)
        {
            vputs("Out of memory!! Epic Fail!!");
            return -1;
        }
        pl_dictionary=(WordKey*)tmp;
        pl_dictionary_size+=sizeof(WordKey)*DICTIONARYSTEP;
    }
    return pl_dictionary_count++;
}


typedef struct CallStateStruct
{
    int lastcall; //the pl_temppos when this word was first called
    CallStateStruct* previous;    
} CallState;

int pl_tempstack[MAXTEMPSTACK];
int pl_temppos=0;
CallState* callstate; 
void pl_temppush(int val)
{
    if(pl_temppos>=MAXTEMPSTACK)
    {
        vputs("Temporary stack overflow\n");
        return;
    }
    pl_tempstack[pl_temppos]=val;
    pl_temppos++;
}
int pl_temppop()
{
    if(pl_temppos<=0)
    {
        vputs("Temporary stack underflow\n");
        return 0;
    }
    return pl_tempstack[pl_temppos--];
}

int forth_execute(uint8_t* block, int length)
{
    uint16_t pos=0;
    printf("block length: %x\r\n",length);
    while(pos<length)
    {
        //serial.getc();
        Opcode op=(Opcode)block[pos];
        printf("pos: %x -- opcode: %x\r\n",(int)pos, (int)op);
        switch(op)
        {
            case BranchTrue:
                if(pl_pop()){
                    pos++;
                    pos=*((uint16_t*)&block[pos]);
                    
                }else{
                    pos+=3;
                }
                break;
            case BranchFalse:
                if(!pl_pop()){
                    pos++;
                    serial.printf("branch false %x\r\n",(int)pos);
                    pos=*((uint16_t*)&block[pos]);
                    serial.printf("branch false %x\r\n",(int)pos);
                }else{
                    pos+=3;
                    serial.printf("branch false skip %x\r\n", (int)pos);
                }
                break;
            case Branch:
                pos++;
                pos=*((uint16_t*)&block[pos]);
            break;
            case Push:
                pos++;
                pl_push(*(uint32_t*)&block[pos]);
                pos+=4;
                break;
            case Drop:
                pos++;
                pl_pop();
                break;
            case Add:
                pos++;
                pl_push(pl_pop()+pl_pop());
                break;
            case Sub:
                pos++;
                pl_push(pl_pop()-pl_pop());
                break;
            case Mul:
                pos++;
                pl_push(pl_pop()*pl_pop());
                break;
            case Div:
                pos++;
                pl_push(pl_pop()/pl_pop());
                break;
            case Mod:
                pos++;
                pl_push(pl_pop()%pl_pop());
                break;
            case Cgt:
                pos++;
                pl_push(pl_pop()>pl_pop());
                break;
            case Clt:
                pos++;
                pl_push(pl_pop()<pl_pop());
                break;
            case Cgte:
                pos++;
                pl_push(pl_pop()>=pl_pop());
                break;
            case Clte:
                pos++;
                pl_push(pl_pop()<=pl_pop());
                break;
            case Ceq:
                pos++;
                pl_push(pl_pop()==pl_pop());
                break;
            case Cneq:
                pos++;
                pl_push(pl_pop()!=pl_pop());
                break;
            case CallInt:{
                pos++;
                uint32_t tmp=*(uint32_t*)&block[pos];
                ((BuiltinFunction)tmp)();
                pos+=4;
                break;}
            case Swap:{
                pos++;
                int tmp=pl_pop();
                int tmp2=pl_pop();
                pl_push(tmp);
                pl_push(tmp2);
                break;
                }
            case PushTemp:
                pos++;
                pl_temppush(pl_pop());
                break;
            case PopTemp:
                pos++;
                pl_push(pl_temppop());
            case Pick:{
                pos++;
                int tmp=pl_pop();
                if(pl_stackpos-tmp>0){
                    pl_push(pl_stack[pl_stackpos-tmp]);
                    
                }else{
                    pl_push(0);
                    vputs("Stack underflow on pick\n");
                }
                break;}
            case Ret:
                return 0;
            
                
            default:
                vputs("Unknown opcode!!");
                return;
        }
    }
    return 0;
}