#include "mbed.h"

#define PinA1 D14 //外部中断0
#define PinZ1 D12 //外部中断1
#define PinB1 D15 //编码器的OUT_B信号连接到数字端口8

#define PinA2 D8 //外部中断0
#define PinZ2 D6 //外部中断1
#define PinB2 D7 //编码器的OUT_B信号连接到数字端口8

#define PinA3 D4 //外部中断0
#define PinZ3 D3 //外部中断1
#define PinB3 D2 //编码器的OUT_B信号连接到数字端口8
#define T 30    //定义采集时间周期单位ms

Timer f;
unsigned long time1 = 0; // 时间标记
volatile long PulSum_CW = 0;   //定义长整型不可修改脉冲数
volatile long PulSum_CCW = 0;   


long PulSum_CW_t0 = 0;         //定义记录顺时针方向 t0 时刻脉冲数变量
long PulSum_CW_t0_T = 0;       //定义记录顺时针方向 t0+T 时刻脉冲数变量


float Rad_CW_Speed = 0.000;    //定义顺时针角速度
float Rad_CCW_Speed = 0.000;    //定义逆时针角速度

DigitalIn ain11(PinA1);//因为编码器信号为欧姆龙E6B2-CWZ6C，为开漏输出，因此需要上拉电阻，此处采用arduino的内部上拉输入模式，置高
DigitalIn ain12(PinB1);//同上
DigitalIn ain13(PinZ1);//脉冲中断函数：捕捉A相信号，并判断A、B相先后顺序
    
DigitalIn ain21(PinA2);//因为编码器信号为欧姆龙E6B2-CWZ6C，为开漏输出，因此需要上拉电阻，此处采用arduino的内部上拉输入模式，置高
DigitalIn ain22(PinB2);//同上
DigitalIn ain23(PinZ2);//脉冲中断函数：捕捉A相信号，并判断A、B相先后顺序
    
DigitalIn ain31(PinA3);//因为编码器信号为欧姆龙E6B2-CWZ6C，为开漏输出，因此需要上拉电阻，此处采用arduino的内部上拉输入模式，置高
DigitalIn ain32(PinB3);//同上
DigitalIn ain33(PinZ3);//脉冲中断函数：捕捉A相信号，并判断A、B相先后顺序



long PulSum_CCW_t0 = 0;        //定义记录逆时针方向 t0 时刻脉冲数变量
long PulSum_CCW_t0_T = 0;      //定义记录逆时针方向 t0+T 时刻脉冲数变量

// 记录角度
int Rad = 180;



void loop()
{
  // 角度计算程序
  Rad = int((PulSum_CW - PulSum_CCW)/6.944) % 360; 
  if (Rad>=180) {
    Rad = Rad - 360;
  }
  
  PulSum_CW_t0   = PulSum_CW;  
  PulSum_CCW_t0   = PulSum_CCW;    //采集t0时刻的脉冲数
  wait(T);                                                     //等待一个T时间
  PulSum_CW_t0_T = PulSum_CW;  
  PulSum_CCW_t0_T = PulSum_CCW;    //采集t0+T时刻的脉冲数
  wait(T);                                                     //等待一个T时间
  
  // 如果检测到正向角速度，那么就打印角速度，以及累计的角度
  if (PulSum_CW_t0_T - PulSum_CW_t0 != 0){
    Rad_CW_Speed = (PulSum_CW_t0_T - PulSum_CW_t0);   //
    // 显示正向(CW)角速度 Rad_CW_Speed--->              //打印出来速度
    //printf("AS:");                            //打印出来速度w
    printf("%f", Rad_CW_Speed);
    printf(":");            
    //printf("/A:");
    printf("%d",Rad);
    printf("\n");
    }  
  
  // 如果检测到反向角速度，那么就打印角速度，以及累计的角度
  if (PulSum_CCW_t0_T - PulSum_CCW_t0 != 0){
    Rad_CCW_Speed = (PulSum_CCW_t0 - PulSum_CCW_t0_T);
    //printf("AS:");
    printf("%f", Rad_CCW_Speed);
    printf(":");            
    //printf("/A:");
    printf("%d",Rad);
    printf("\n");
    }



}
void Encode()
{//当编码器码盘的OUTA脉冲信号下跳沿每中断一次，
  f.start();
  uint32_t m = f.read_ms();
  if ((m - time1) > 5)
  {
    if (((ain11 == 0) && (ain12 == 1)) || ((ain21 == 0) && (ain22 == 1))  || ((ain31 == 0) && (ain32 == 1)) )
    {PulSum_CW ++;}
    else
    {PulSum_CCW ++;}
  }
    time1 = m;
  f.stop();
}
