#include "mbed.h"

#define PinA D9 //A phase
#define PinZ D14     //Z phase
#define PinB D8 //B phase

#define time2 10000
#define HIGH 1
#define LOW 0

//Initialize Variable
int counter_cw = 0;
const float d = 0.058; //Diameter of the wheel
const float pi = 3.141592654;//PI
int num = 0;//number of turns
double t;//time per turn
float velocity;
int current = 0;
int temp = 0;
int n = 0;
double time3;//Time of phase Z detected, use for calculate the velocity
Timer f;


DigitalIn a12(PinB);
InterruptIn a11(PinA);
InterruptIn a13(PinZ);


Serial pc(USBTX, USBRX);

void Encode0()
{
        if((a11 == HIGH) && (a12 == LOW))
        
        {   counter_cw++;

        }
        
             else
        
        {  counter_cw--; 
        
        
        
        }
    
}

void setup(){
    a11.mode(PullUp);
    a12.mode(PullUp);
    a11.rise(&Encode0);
}

void Set_state(int a){
    counter_cw = a;
    n = 0;
}

void loop()

{
    double  distance;
    //clockwise turning
    n = n + 2;
    if (counter_cw >= 2500)
    {
      temp = counter_cw / 2500;
      current = counter_cw - 2500 * temp;
      t = n;
      Set_state(current);
      velocity = (temp * d * pi) / t;
      pc.printf("The wheel has run ");pc.printf("%f", distance); pc.printf("m.");
      pc.printf("The cw_speed is ");pc.printf("%f", velocity); pc.printf("m/s.");
    }
    //anti-clockwise turning
    else if (counter_cw >= -2500)
    {
      temp = counter_cw / 2500;
      current = counter_cw + 2500 * temp;
      t = n;
      Set_state(current);
      velocity = d * pi / t;
      pc.printf("The wheel has run ");pc.printf("%f", distance); pc.printf("m.");
      pc.printf("The cw_speed is ");pc.printf("%f", velocity); pc.printf("m/s.");
    }
}



int main(){
    setup();
    pc.printf("start");
    f.start();
    while(1){
        loop();
        wait(2);
        pc.printf("%d %d \r\n", counter_cw, counter_ccw);
    }
}