#include "mbed.h"
#include "QEI.h"
#include "define.h"//defineしてるだけのファイル
#include "string" // string クラスを使用するために宣言
using std::string;

Serial pc(USBTX,USBRX,115200);
RawSerial sabertooth1(p13,NC,115200);
RawSerial master(p9,p10,115200);
//library
Timer t;
QEI enc(p29,p30,NC,500,&t,QEI::X4_ENCODING);
Timer a;
Timer valve;
AnalogIn sensor1(p19);//光電センサ
AnalogIn sensor2(p20);
DigitalOut vl2(p24);
DigitalOut vl1(p25);
DigitalOut vl3(p26);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn limit2 (p8);
DigitalIn limit1 (p7);
DigitalIn limit3 (p15);

Ticker flipper;
bool state_flag = false;
//double time_count=0;
int count2 = 0;

double rad = 0.0;//rad/s
double pre_rad = 0.0;//前のrad/s
double deg = 0.0;//角度
double pre_deg = 0.0;//前の角度
double error1 = 0.0;

double rad_error = 0.0;
double pre_rad_error = 0.0;

double deg_error = 0.0;
double pre_deg_error = 0.0;

double encount;
double cmd = 0.0;//計算結果
double ref_deg;//目標角度

double inte_deg_error = 0.0;

double error_diff_deg = 0.0;

double para_gain1 = 4.0;//位置比例のゲイン
double inte_gain1 = 0.0;//位置積分のゲイン
double diff_gain1 = 0.0;//位置微分のゲイン

string recv_str = ""; // 受信した文字列
int recv_data = 0; // 受信した数値
int raw_sw_data = 0;// 受信したスイッチのデータ
int sw_data = 0;
int countX = 0;
int countB = 0;
int countV = 0;
bool kari_time = false;
bool flag_10ms = false;//false = 0, true = 0以外
bool v_flag = false;//0

int limitSW1 = 0;
int limitSW3 = 0;

/*************************************通信処理***************************************/
void recv_warikomi()
{
    char c = master.getc(); //一時的に変数に格納

    if(c == '\n') { // 改行が来たら受信終了
        if(recv_str.size() == 2) {
            // 受信文字数が1文字+改行コード1文字だった場合にのみ数値に変換
            recv_data = strtol(recv_str.c_str(), NULL, 16);

            raw_sw_data = recv_data & 0xFF;

            if(raw_sw_data==BUTTON_R1) {
                sw_data = BUTTON_R1;
            } else if(raw_sw_data==BUTTON_L1) {
                sw_data = BUTTON_L1;
            }  else if(raw_sw_data==BUTTON_LEFT) {
                sw_data = BUTTON_LEFT;
            } else if(raw_sw_data==BUTTON_X) {
                sw_data = BUTTON_X;
            } else if(raw_sw_data==BUTTON_Y) {
                sw_data = BUTTON_Y;
            } else if(raw_sw_data==BUTTON_A) {
                sw_data = BUTTON_A;
            } else if(raw_sw_data==BUTTON_B) {
                sw_data = BUTTON_B;
            } else if(raw_sw_data==RECEIVED_DISTANCE) {
                sw_data = RECEIVED_DISTANCE;
            }
        }
        recv_str = ""; // 文字列を初期化

    } else { // それ以外はひたすら文字列を追加していく
        recv_str += c;
    }
}
/************************************************************************************/
void flip()
{
    flag_10ms = true;
//角度計算
    encount = (double)enc.getPulses();
    //rad = encount*ENC_COE;//1周が6.28になるように変更
    deg = encount*ENC_COE;//ここ変な計算してない？
    //ここから位置PID制御
    double deg_error = ref_deg - deg;
    static double pre_deg_error = deg_error;

    inte_deg_error += ((deg_error+pre_deg_error)*T)/2.0;
    error_diff_deg = (deg_error - pre_deg_error)/T;//D制御

    cmd = deg_error*para_gain1+inte_deg_error*inte_gain1+error_diff_deg*diff_gain1;

    if(cmd > 500.0) {
        cmd = 500.0;
    } else if(cmd < -200.0) {
        cmd = -200.0;
    }

    if(sensor1.read() < 0.30 && state_flag == false) {
        enc.qei_reset();
        cmd = 0.0;
    }
    sabertooth1.printf("M1:%d\r\n",(int)cmd);

    pre_deg = deg;

    //pc.printf("deg:%lf count:%lf ref:%lf timer:a:%f\r\n",deg,time_count,ref_deg,a.read());
    // pc.printf("%f\r\n", a.read());
    //pc.printf("%f %d %d\r\n",a.read(),v_flag,countV);
    //pc.printf("sw:%x v_flag:%d ref_deg:%lf deg:%lf enc:%lf\r\n",sw_data, v_flag,ref_deg,deg,encount);
    //pc.printf("sensor:%f\r\n",sensor1.read(),);
}

int main()
{
    vl1=0;
    vl3=0;
    led4=1;
    wait(0.5);
    led4=0;
    wait(0.5);
    led4=1;
    wait(0.5);
    led4=0;
    master.baud(115200);
    master.attach(recv_warikomi, Serial::RxIrq);
    flipper.attach(flip,T);//周期割込み

    while(1) {
        if(flag_10ms) {
            /**************************移住船関連の処理*************************************/
            if(sw_data == BUTTON_L1) { // 手動でdown
                vl1 = 0;
                v_flag = true;
                valve.start();
                sw_data = BUTTON_EMPTY;
            } else if(sw_data == BUTTON_R1) { // 手動でup
                vl1 = 1;
            } else if(a.read() >= HAND && !v_flag) { // タイマーが設定した時間に達したらup & タイマーストップとリセット
                vl1 = 1;
                a.stop();
                a.reset();
            } else if(limit1.read() == 0 && limit3.read() == 0 && !v_flag) { // リミットスイッチが反応したらタイマースタート
                a.start();
            } else if(sw_data == BUTTON_Y) {
                v_flag = false;
            } else if(valve.read() >= 4.0f) {
                v_flag = false;
                valve.stop();
                valve.reset();
            } else { // それ以外は基本的にタイマーストップとリセット
                a.stop();
                a.reset();
            }

            /**********************************物資処理**************************************/
            if(sw_data == BUTTON_A) {
                ref_deg = 0.0;
                state_flag = false;
                if(sensor1 < 0.30){
                    vl3 = 0;
                }
            }else if(sw_data==BUTTON_X) {
                countB = 0;
                vl3=1;
                ref_deg = REF_MID;

                /*if(countX >= 30) {
                    ref_deg=REF_MID;
                } else {
                    countX++;
                }*/
                state_flag = true;
            } else if(sw_data == RECEIVED_DISTANCE) {
                led1 = 1;
                ref_deg=REF_MAX;
                countX = 0;
            } else if(sw_data==BUTTON_B) {
                vl3=0;
                state_flag = false;
                if(countB >= 200) {
                    ref_deg = 0.0;
                } else {
                    countB++;
                }

            }
            /********************************************************************************/
            flag_10ms = false;
        }
    }
}