#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Controller.h"

#define INT_TIME 0.001
#define INT_TIME_MS INT_TIME*1000

Serial pc(USBTX, USBRX,115200);
Controller con(p9,p10,115200); //TXpin, RXpin, baudrateを設定
//Controller con(p13,p14,115200); //TXpin, RXpin, baudrateを設定
//DigitalOut led_user(LED_USER);
//DigitalOut led_red(LED_RED);
//DigitalOut pin_emergency(D0); //非常停止信号

Ticker interrupt;
bool flag_10ms = false;
bool flag_1s = false;

void interrupt_func()
{
    static int count_10ms = 0;
    if(count_10ms++ > (INT_TIME_MS*10 - 1))
    {
        flag_10ms = true;
        count_10ms = 0;
        
        static int count_1s = 0;
        if(count_1s++ > (INT_TIME_MS*100 -1))
        {
            flag_1s = true;
            count_1s = 0;
        }
    }
}

int main()
{   
    //pc.baud(115200);
    
    /* 第一引数はタイムアウト時間[ms]，第二引数はupdate関数の呼び出し周期[ms] */
    con.init(1000, INT_TIME_MS*10); //init関数を呼び出さなければタイムアウトの処理は行われない（available関数は常にtrueを返す）
    
    interrupt.attach(&interrupt_func, INT_TIME);
    
    while(1) 
    {
        //pc.printf("");
        if(flag_10ms)
        {
            con.update(); //main関数のflag内で呼び出す．
            if(con.available())
            {
                int buttonState = con.getButtonState();
                uint8_t joyRx = con.readJoyRXbyte();
                uint8_t joyRy = con.readJoyRYbyte();
                uint8_t joyLx = con.readJoyLXbyte();
                uint8_t joyLy = con.readJoyLYbyte();
                
                pc.printf("%u\t", buttonState);
                pc.printf("%u\t", joyRx);
                pc.printf("%u\t", joyRy);
                pc.printf("%u\t", joyLx);
                pc.printf("%u\r\n", joyLy);
                
                //led_red.write(1);
                //pin_emergency.write(1); //非常停止を解除する
            }
            else
            {
                pc.printf("disconnected\r\n");
                //led_red.write(0);
                //pin_emergency.write(0); //非常停止を作動させる
            }
            
            flag_10ms = false;
        }
        
        if(flag_1s)
        {
            //led_user.write(!led_user.read());
            flag_1s = false;
        }
        wait_us(1);
        //thread_sleep_for(1);
    }
}
