#include "mbed.h"//LPC1768でパルス取得
#include "QEI.h"
#include "math.h"
#define Z_A 16
#define Z_B 35
#define ZZ 2000
#define REAL 54
#define LIMIT 0.5
Serial pc(USBTX,USBRX,115200);

DigitalOut dir(p21);
PwmOut pwm(p22);
Ticker Diff;
Timer t;
QEI enc(p27, p28, NC, 500, &t, QEI::X4_ENCODING);//エンコーダのライブラリ
DigitalIn SW(p20);
DigitalOut RLED(p19);
DigitalOut YLED(p17);
DigitalOut GLED(p15);
double angle,radspeed,pre_dist,dist,vel;
double ref_vel = 0.0;// 目標速度(Reference Velocity) mm/s
double ref_dist = 0.20;// 目標位置(Reference Ddist) m

double Kpv = 0.5;//速度制御の比例ゲイン
double Kiv = 0.0;//速度制御の積分ゲイン
double Kdv = 0.0;//速度制御の微分ゲイン

double Kpd = 5.0;//位置制御の比例ゲイン
double Kid = 1.0;//位置制御の積分ゲイン
double Kdd = 0.0;//位置制御の微分ゲイン
double Int_dist_error = 0;
double Int_vel_error = 0;
int encount;
double cmd = 0;
int k;

void diff(){

    encount = enc.getPulses();
    dist=(double)encount*REAL*Z_A/(Z_B*ZZ*1000);//[m]
    vel=(dist-pre_dist)/0.01;
    pre_dist=dist;


    double dist_error = ref_dist - dist;
    static double pre_dist_error = dist_error;
    
    Int_dist_error += (dist_error+pre_dist_error)*0.01/2.0;
    ref_vel = dist_error*Kpd +Int_dist_error*Kid + (dist_error - pre_dist_error)/0.01 * Kdd;
    
    double vel_error = ref_vel-vel;
    static double pre_vel_error = vel_error;
    
    Int_vel_error += (vel_error+pre_vel_error)*0.01/2.0;
    cmd += vel_error*Kpv +Int_vel_error*Kiv + (vel_error - pre_vel_error)/0.01 * Kdv;
    pre_dist_error = dist_error;    
    
    if(cmd > LIMIT) cmd = LIMIT;
    else if(cmd < -LIMIT) cmd = -LIMIT;

    if(cmd >= 0) {
        dir.write(1);//モータ回転方向指定
        k=1;
    } else {
        dir.write(0);
        k=0;
    }

    pwm.write(fabs(cmd));
    GLED=1.0;
   
}

int main()
{
    pwm.period_us(50);
    int sw;
    do {
        sw=SW.read();
        dir=0.0;
        pwm.write(0.3);

    } while(sw!=1);

    pwm.write(0.0);

    wait(3.0);
    enc.qei_reset();
    Diff.attach(&diff,0.01);
    while(1) {
 pc.printf("dist:%lf ref_vel:%lf\r\n",dist,ref_vel);
    }
}
