#ifndef DEFINE_h
#define DEFINE_h

#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

struct coords {
    double x;
    double y;
    double z;
};

#define RED  0
#define BLUE 1

#define SERIAL_UPPER    Serial0
#define SERIAL_LPMSME1  Serial1
#define SERIAL_ROBOCLAW Serial4
// #define SERIAL_CON      Serial5
#define SERIAL_CON      Serial7 // XBeeからコントローラデータを受信する場合
#define SERIAL_LCD      Serial6
#define SERIAL_M5STACK  Serial6
//#define SERIAL_XBEE     Serial7

#define PIN_XBEERESET 66

// スイッチやLEDのピン設定
#define PIN_DIP1 25
#define PIN_DIP2 24
#define PIN_DIP3 69
#define PIN_DIP4 70

#define PIN_SW_UP    32
#define PIN_SW_LEFT  33
#define PIN_SW_RIGHT 31
#define PIN_SW_DOWN  30

#define PIN_SW_B  29
#define PIN_SW_A  28

#define PIN_ENC_A  26
#define PIN_ENC_B  27

#define PIN_LED_1 20
#define PIN_LED_2 36
#define PIN_LED_3 37
#define PIN_LED_4 38
#define PIN_LED_ENC 40

// 制御周期
#define INT_TIME			( 0.01 )//( 0.001 )

// >>> AutoControlで使用 >>>>>>>>>>>>>>>>>>
// フェーズ管理
#define STATE0  ( 7 )
#define STATE1  ( 8 )
#define STATE2  ( 9 )
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

// >>> ManualControlで使用 >>>>>>>>>>>>>>>>>>
#define JOY_DEADBAND    ( 2 )
#define JOY_MAXVEL      ( 0.5 )
#define JOY_MAXANGVEL   ( 2.5 )
#define MANUAL_LOWPASS_T  ( 0.01 )
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

// >>> PathTrackingで使用 >>>>>>>>>>>>>>>>>>
#define POSI_X_KP    ( 2.5 )
#define POSI_X_KI    ( 0.0 )
#define POSI_X_KD    ( 5.0 )

#define POSI_Y_KP    ( 3.0 )
#define POSI_Y_KI    ( 0.0 )
#define POSI_Y_KD    ( 2.0 )

#define POSI_Z_KP    ( 4.0 )
#define POSI_Z_KI    ( 0.0 )
#define POSI_Z_KD    ( 0.0 )

#define YOKOZURE_KP    ( 3.0 )
#define YOKOZURE_KI    ( 0.0 )
#define YOKOZURE_KD    ( 1.5 )

#define KAKUDO_KP    ( 4.0 )
#define KAKUDO_KI    ( 0.0 )
#define KAKUDO_KD    ( 0.0 )

#define FILT_SOKUDO_OMEGA ( 22.0 )
#define FILT_SOKUDO_DZETA ( 1.0 )

#define FILT_KAKUDO_OMEGA ( 10.0 )
#define FILT_KAKUDO_DZETA ( 1.0 )
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

// >>> Platformで使用 >>>>>>>>>>>>>>>>>>>>>
// Platformの種類を設定
#define PLATFORM_MECHANUM      ( 0 )
#define PLATFORM_OMNI4WHEEL    ( 1 )
#define PLATFORM_OMNI3WHEEL    ( 2 )
#define PLATFORM_DUALWHEEL     ( 3 )
#define PLATFORM_ACTIVECASTER3WHEEL (4)
#define PLATFORM_ACTIVECASTER$WHEEL (5)

#define DRIVE_UNIT  ( PLATFORM_ACTIVECASTER3WHEEL )

#if DRIVE_UNIT == PLATFORM_DUALWHEEL
// 双輪キャスター関連
#define PIN_CSB     ( 10 )    // turntableのPIN(CSB)
#define RADIUS_R    ( 0.04 )    // wheel radius
#define RADIUS_L    ( 0.04 )    // wheel radius
#define W           ( 0.265 )    // tread
#define GEARRATIO   ( 5.5 )
#define TT_RES4     ( 4096 )    // turntableの分解能
#define _2RES_PI    ( 2 * 2048 / M_PI ) // 駆動輪の角速度[rad/s]からRoboClawの指令値[pulses/s]に変換するための定数(2048はエンコーダ分解能) 4逓倍しているが，分母は元は2*piで，通分されている
#define _2RES_PI_T  ( 2 * 500 / M_PI ) //  ターンテーブルの角速度[rad/s]からRoboClawの指令値[pulses/s]に変換するための定数(500はエンコーダ分解能) 4逓倍しているが，分母は元は2*piで，通分されている
#elif DRIVE_UNIT == PLATFORM_MECHANUM
// メカナム関連
#define WHEEL_R		( 0.0635 )    //車輪半径
#define TREAD_2 	( 0.296 ) //車両中心から車輪接地点までのY軸方向距離(トレッド/2)
#define WHEELBASE_2	( 0.265 ) //車両中心から車輪接地点までのX軸方向距離(ホイールベース/2)
#define _2RES_PI  ( 2.0 * 500 / M_PI ) //  駆動輪の角速度[rad/s]からRoboClawの指令値[pulses/s]に変換するための定数(2048はエンコーダ分解能) 4逓倍しているが，分母は元は2*piで，通分されている
#elif DRIVE_UNIT == PLATFORM_OMNI3WHEEL
#define WHEEL_R		( 0.019 )
#define DIST2WHEEL  ( 0.120 )
#define GEARRATIO   ( 51.45 )
#define COS_PI_6    ( 0.86602540378 )
#define SIN_PI_6    ( 0.5 )
#define _2RES_PI    ( 2.0 * 2048 / M_PI ) // 駆動輪の角速度[rad/s]からRoboClawの指令値[pulses/s]に変換するための定数(2048はエンコーダ分解能) 4逓倍しているが，分母は元は2*piで，通分されている
#elif DRIVE_UNIT == PLATFORM_OMNI4WHEEL
#define WHEEL_R (0.0635)
#define DIST2WHEEL (0.421185)               //中心からホイールまでの距離
#define GEARRATIO   ( 1.0 )           // 車輪からエンコーダの計測軸までのギヤ比(1:1 なら 1)
#define COS_PI_4    ( 0.70711 )         // cos(pi/4)
#define SIN_PI_4    ( 0.70711 )         // sin(pi/4)
#define _2RES_PI (2.0 * 1024.0 / M_PI ) //  [rad/s]からRoboClawの指令値[pulses/s]に変換するための定数(1024はエンコーダ分解能) 4逓倍しているが，分母は元は2*piで，通分されている
#elif DRIVE_UNIT == PLATFORM_ACTIVECASTER3WHEEL
	#define OFFSET (0.04)//車輪のオフセット値
	#define ABS_ENCRES (16384.0) //アブソリュートエンコーダの分解能
	#define GEAR_RATIO_ENC (1.0) //操舵軸とエンコーダ計測軸とのギア比(ギアが入ってなければ1で)
	#define GEAR_RATIO_TRANS (3.0) //モーター軸と大歯車のギア比
	#define WHEEL_R (0.03)//車輪半径
	#define PI (3.141592)
	#define W1_x (0.2753)//操舵軸の座標
	#define W1_y (0.0)
	#define W2_x (-0.1376)
	#define W2_y (0.2384)
	#define W3_x (-0.1376)
	#define W3_y (-0.2384)
	#define MAX_RPM (400)
	#define PIN_CSB_1 P4_0
	#define PIN_CSB_2 P1_2
	#define PIN_CSB_3 P2_13
	#define PIN_PWM_1A P8_11
	#define PIN_PWM_1B P8_13
	#define PIN_PWM_2A P5_5
	#define PIN_PWM_2B P5_0
	#define PIN_PWM_3A P4_4
	#define PIN_PWM_3B P4_5
	#define PIN_DIR_1A P5_4
	#define PIN_DIR_1B P5_4
	#define PIN_DIR_2A P5_7
	#define PIN_DIR_2B P5_6
	#define PIN_DIR_3A P5_2
	#define PIN_DIR_3B P5_1
	
	//activecaster unit1(P8_11,P8_13,P5_4,P5_3);//ピン宣言
	//activecaster unit2(P5_5,P5_0,P5_7,P5_6);
	//activecaster unit3(P4_4,P4_5,P5_2,P5_1);
	/*       +x
	          o--W1
	          |
	+y________|_________-y
	          |
	    o--W2 |     o--W3
	         -x
	        */
#endif

// RoboClaw関連
#define ADR_MD1             ( 130 )
#define ADR_MD2             ( 129 )

// 自己位置推定用エンコーダ関連
#define _2PI_RES4   ( 2 * 3.141592 / 800 ) // res = 200 分母は res*4
#define RADIUS_X    ( 0.024 ) // X軸計測輪の半径[m]
#define RADIUS_Y    ( 0.024 ) // Y軸計測輪の半径[m]
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

// >>> Controllerまわりで使用 >>>>>>>>>>>>>>>>>>>>>
#define CON_ADACHI    ( 0 )
#define CON_ELECOM    ( 1 )
#define CON_DS4       ( 2 )

#define CON_TYPE  ( CON_DS4 )

#if CON_TYPE == CON_ADACHI
#define MASK_BUTTON_UP    0x01
#define MASK_BUTTON_RIGHT 0x02
#define MASK_BUTTON_DOWN  0x04
#define MASK_BUTTON_LEFT  0x08
#define MASK_BUTTON_R1    0x10
#define MASK_BUTTON_R2    0x20
#define MASK_BUTTON_L1    0x40
#define MASK_BUTTON_L2    0x80

#define BUTTON_UP    1
#define BUTTON_RIGHT 2
#define BUTTON_DOWN  3
#define BUTTON_LEFT  4
#define BUTTON_R1    5
#define BUTTON_R2    6
#define BUTTON_L1    7
#define BUTTON_L2    8
#elif CON_TYPE == CON_ELECOM || CON_TYPE == CON_DS4
#define MASK_BUTTON_X  0x0001
#define MASK_BUTTON_Y  0x0002
#define MASK_BUTTON_A  0x0004
#define MASK_BUTTON_B  0x0008

#define MASK_BUTTON_SHIKAKU 0x0001
#define MASK_BUTTON_SANKAKU 0x0002
#define MASK_BUTTON_BATU    0x0004
#define MASK_BUTTON_MARU    0x0008

#define MASK_BUTTON_L1     0x0010
#define MASK_BUTTON_R1     0x0020
#define MASK_BUTTON_L2     0x0040
#define MASK_BUTTON_R2     0x0080

#define MASK_BUTTON_PAD     0x0100 // PS4のときはPADボタン
#define MASK_BUTTON_PS      0x0200 // PS4のときはPS
#define MASK_BUTTON_JOY_L   0x0100
#define MASK_BUTTON_JOY_R   0x0200
#define MASK_BUTTON_BACK    0x0400
#define MASK_BUTTON_START   0x0800
#define MASK_BUTTON_SHARE   0x0400
#define MASK_BUTTON_OPTION  0x0800

#define MASK_BUTTON_UP     0x1000
#define MASK_BUTTON_RIGHT  0x2000
#define MASK_BUTTON_DOWN   0x4000
#define MASK_BUTTON_LEFT   0x8000

#define BUTTON_UP    13
#define BUTTON_RIGHT 14
#define BUTTON_DOWN  15
#define BUTTON_LEFT  16
#define BUTTON_R1    6
#define BUTTON_R2    8
#define BUTTON_L1    5
#define BUTTON_L2    7
#endif
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

#endif
