/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

//アクティブキャスタ制御用プログラム

//#include "AutoControl.h"

#include "LpmsMe1Peach.h"
#include "SDclass.h"
#include "phaseCounterPeach.h"
#include "AMT22.h"
#include "Filter.h"
#include "mbed.h"
#include "Controller.h"
#include "define.h"
#include "ManualControl.h"
#include "DDSScontrol.h"
#include "Platform.h"
Serial pc(USBTX,USBRX,115200);

ManualControl manualCon;
Controller con(P7_4,P7_5, 115200); //TXpin, RXpin, baudrateを設定

Platform _platform(1,1,1,1);
PhaseCounter enc1(1);
PhaseCounter enc2(2);
int encounter1, encounter2;

Serial serialLpms(P2_5, P2_6);
LpmsMe1 lpms(&serialLpms);

mySDclass mySD;
//AutoControl autonomous;
Ticker timer;
DigitalIn sw_user(P6_0);

DigitalOut led_blue(LED_BLUE);
DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);

DigitalOut pin_led_1(P3_9);
DigitalOut pin_led_2(P2_0);

DigitalOut led(LED_USER);
DigitalOut enable(P2_9);

float angle = 0.0;
bool flag10ms = false;


void warikomi()
{
    //
    static int counter1ms = 0;
    counter1ms++;

    static float count = 0;

    encounter1 = enc1.getCount();
    encounter2 = enc2.getCount();

    if (counter1ms == 10) {
        flag10ms = true;
        counter1ms = 0;
    }
}

int main()
{
    wait(1.0);
    coords initposi = {0.0,0.0,0.0};
    _platform.platformInit(initposi);
    enc1.init();
    enc2.init();
    lpms.init();
    //con.init(1000, 0.01*10);
    manualCon.init();
    
    pc.printf("Hello World\r\n");
    while(sw_user.read()) {
        static int led_count=0;
        led_count++;
        if(led_count<10) {
            led_blue = 1;
        } else if(led_count >= 10 && led_count<20) {
            led_blue = 0;
        } else if(led_count>=20) {
            led_count = 0;
        }
        wait(0.1);
        pc.printf(">>push the button<<");
        pc.printf("\033[1;1f");
    }
    pc.printf("program start");
    wait(1.0);

    led_blue = 0;
    timer.attach(&warikomi, 0.001);
    int count = 0;
    int absencount = 0;
    while (true) {
        if (flag10ms) {
            count++;
            coords local_refV;
            coords global_refV;
            angle = lpms.get_z_angle();

            uint8_t joyRx ;
            uint8_t joyRy;
            uint8_t joyLx;
            uint8_t joyLy;
            unsigned int buttonState;
            static int count_com_error = 0;
            bool flag_connect;
            //con.update(); //main関数のflag内で呼び出す．
            if(con.update()) {
                buttonState = con.getButtonState();
                joyRx = con.readJoyRXbyte();
                joyRy = con.readJoyRYbyte();
                joyLx = con.readJoyLXbyte();
                joyLy = con.readJoyLYbyte();

                led=!led;
                led_red = 0;
                led_green = 1;
                count_com_error = 0;
                enable = 1;
                flag_connect = true;
            } else {
                led=0;
                count_com_error++;
                if(count_com_error > 50) {
                    enable  = 0;
                    led_green = 0;
                    led_red = 1;
                    //pc.printf("disconnected!!\r\n");
                    local_refV.x = 0;
                    local_refV.y = 0;
                    local_refV.z = 0;
                    flag_connect = false;
                }
            }

////////////////////////////指令値生成///////////////////////////////////////////
            local_refV = manualCon.getRefVel(joyLx,joyLy,joyRy);
            global_refV.x = local_refV.x * cos(angle) + local_refV.y * sin(angle);
            global_refV.y = local_refV.y * cos(angle) - local_refV.x * sin(angle);
            global_refV.z = local_refV.z;

            _platform.VelocityControl(global_refV);
            
            if (count >= 50) {
                pin_led_1 = !pin_led_1;
                pin_led_2 = !pin_led_2;
                count = 0;
            }
            flag10ms = false;
        }
        thread_sleep_for(1);
    }

}