/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

//アクティブキャスタ制御用プログラム

//#include "AutoControl.h"

#include "LpmsMe1Peach.h"
#include "SDclass.h"
#include "phaseCounterPeach.h"
#include "AMT22.h"
#include "Filter.h"
#include "mbed.h"
#include "Controller.h"
#include "define.h"
#include "ManualControl.h"
Serial pc(USBTX,USBRX,115200);

ManualControl manualCon;
//Timer t;
//QEI onboard_enc(P5_2, P5_3, NC, 24, &t, QEI::X4_ENCODING);
Controller con(P7_4,P7_5, 115200); //TXpin, RXpin, baudrateを設定
//#include "platform/mbed_thread.h"


#define ABS_ENC_RES 16384
#define enc_gear_ratio 3
#define MAX_RPM 400.0

double abs_enc_rad(int abscount)
{
    return (double)abscount * 6.28 / (ABS_ENC_RES * GEAR_RATIO_ENC);
}

PhaseCounter enc1(1);
PhaseCounter enc2(2);
int encounter1, encounter2;

Serial serialLpms(P2_5, P2_6);
LpmsMe1 lpms(&serialLpms);

SPI spi(P10_14, P10_15, P10_12); // mosi, miso, sclk
AMT203V absenc_1(&spi, PIN_CSB_1);
AMT203V absenc_2(&spi, PIN_CSB_2);
AMT203V absenc_3(&spi, PIN_CSB_3);

mySDclass mySD;
//AutoControl autonomous;

double Vr_omega = 0;

Ticker timer;



DigitalIn sw_user(P6_0);

DigitalOut led_blue(LED_BLUE);
DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);

DigitalOut pin_led_1(P3_9);
DigitalOut pin_led_2(P2_0);

/*DigitalIn pin_sw_white(P5_0);
DigitalIn pin_sw_yellow(P5_1);
DigitalIn pin_sw_up(P7_15);
DigitalIn pin_sw_right(P2_10);
DigitalIn pin_sw_left(P8_1);
DigitalIn pin_sw_down(P2_9);*/

DigitalOut led(LED_USER);

//DigitalOut enable_1(P3_15);
//DigitalOut dir_1(P3_11);
//PwmOut vel_1(P3_10);

PwmOut pwm_2_a(P5_5);
PwmOut pwm_2_b(P5_0);
PwmOut pwm_1_a(P8_11);
PwmOut pwm_1_b(P8_13);
PwmOut pwm_3_a(P4_4);
PwmOut pwm_3_b(P4_5);

DigitalOut dir_2_a(P5_7);
DigitalOut dir_2_b(P5_6);
DigitalOut dir_1_a(P5_4);
DigitalOut dir_1_b(P5_3);
DigitalOut dir_3_a(P5_2);
DigitalOut dir_3_b(P5_1);

DigitalOut enable(P2_9);

//DigitalOut enable_2(P3_14);
//DigitalOut dir_2(P3_9);
//PwmOut vel_2(P3_8);

float angle = 0.0;
bool flag10ms = false;


void activecaster_control(int wheel_num,double vel_x,double vel_y,double vel_z,double angle_stear)
{
    double Wp_x,Wp_y;//固定点の座標

    switch(wheel_num) {
        case 1:
            Wp_x = W1_x;
            Wp_y = W1_y;
            break;
        case 2:
            Wp_x = W2_x;
            Wp_y = W2_y;
            break;
        case 3:
            Wp_x = W3_x;
            Wp_y = W3_y;
            break;
    }
    double x_w1 = vel_x - Wp_x * vel_z;//固定点の速度
    double y_w1 = vel_y + Wp_y * vel_z;

    double omega_wheel = (x_w1 * cos(angle_stear) + y_w1 * sin(angle_stear)) / 0.03;//操舵角速度
    double omega_stear = (-x_w1 * sin(angle_stear) + y_w1 * cos(angle_stear)) / 0.04;//走行角速度

    double omega_a = GEAR_RATIO_TRANS * omega_wheel - GEAR_RATIO_TRANS * omega_stear;//モーターAの角速度
    double omega_b = GEAR_RATIO_TRANS * omega_wheel + GEAR_RATIO_TRANS * omega_stear;//モーターBの角速度

    double rpm_a = omega_a * 9.549;//角速度から回転数(rpm)に換算するところ
    double rpm_b = omega_b * 9.549;

    double MD_val_A = fabs(rpm_a) * 0.8 / MAX_RPM+0.1;//ESCONの指令値に変換する処理
    double MD_val_B = fabs(rpm_b) * 0.8 / MAX_RPM+0.1;
    if(MD_val_A>0.9) {//ESCONのPWM指令は10%から90%の間で有効なのでその範囲に収める処理
        MD_val_A = 0.9;
    }
    if(MD_val_A<0.1) {
        MD_val_A=0.1;
    }

    if(MD_val_B>0.9) {
        MD_val_B = 0.9;
    }
    if(MD_val_B<0.1) {
        MD_val_B=0.1;
    }
///////////////////////回転方向の指定/////////////////////////////////////////////
    switch(wheel_num) {
        case 1:
            if(rpm_a>0) {
                dir_1_a = 1;
            } else {
                dir_1_a = 0;
            }
            if(rpm_b>0) {
                dir_1_b = 0;
            } else {
                dir_1_b = 1;
            }
            pwm_1_a.write(MD_val_A);
            pwm_1_b.write(MD_val_B);
            break;
        case 2:

            if(rpm_a>0) {
                dir_2_a = 1;
            } else {
                dir_2_a = 0;
            }
            if(rpm_b>0) {
                dir_2_b = 0;
            } else {
                dir_2_b = 1;
            }

            pwm_2_a.write(MD_val_A);
            pwm_2_b.write(MD_val_B);
            break;
        case 3:
            if(rpm_a>0) {
                dir_3_a = 1;
            } else {
                dir_3_a = 0;
            }
            if(rpm_b>0) {
                dir_3_b = 0;
            } else {
                dir_3_b = 1;
            }
            pwm_3_a.write(MD_val_A);
            pwm_3_b.write(MD_val_B);

            break;
    }
    //pc.printf("velx:%lf vely:%lf vel_z:%lf omega_a %lf omega_b %lf dir_a:%d dir_b:%d angle:%lf\r\n",vel_x,vel_y,vel_z,omega_a,omega_b,dir_3_a.read(),dir_3_b.read(),angle_stear);
    //pc.printf("omega_a %lf omega_b %lf dir_a:%d dir_b:%d angle:%lf\r\n",omega_a,omega_b,dir_2_a.read(),dir_2_b.read(),angle_stear);
    //pc.printf("rpm_a:%lf rpm_b:%lf\r\n",rpm_a,rpm_b);
    
}


void warikomi()
{
    //
    static int counter1ms = 0;
    counter1ms++;

    static float count = 0;

    encounter1 = enc1.getCount();
    encounter2 = enc2.getCount();

    if (counter1ms == 10) {
        flag10ms = true;
        counter1ms = 0;
        // RGB LED を良い感じに光らせるための処理


    }
    // pc.printf("test");
}

int main()
{

    //pc.baud(115200);
    pc.printf("program start");
    wait(1.0);

    enc1.init();
    enc2.init();
    lpms.init();
    //con.init(1000, 0.01*10);
    manualCon.init();
    pc.printf("AMT222 initialization %d %d %d\r\n", absenc_1.init(), absenc_2.init(), absenc_3.init());
    pc.printf("Hello World\r\n");
    while(sw_user.read()) {
        static int led_count=0;
        led_count ++;
        if(led_count<1000) {
            led_blue = 1;
        }
        if(led_count >= 1000 && led_count<2000) {
            led_blue = 0;
        }
        if(led_count>=2000) {
            led_count = 0;
        }
        wait(0.5);
    }
    wait(1.0);
    led_blue = 0;
    timer.attach(&warikomi, 0.001);
    int count = 0;
    int absencount = 0;
    while (true) {
        if (flag10ms) {
            count++;
            coords refV;
            angle = lpms.get_z_angle();

            uint8_t joyRx ;
            uint8_t joyRy;
            uint8_t joyLx;
            uint8_t joyLy;
            unsigned int buttonState;
            static int count_com_error = 0;
            //con.update(); //main関数のflag内で呼び出す．
            if(con.update()) {
                buttonState = con.getButtonState();
                joyRx = con.readJoyRXbyte();
                joyRy = con.readJoyRYbyte();
                joyLx = con.readJoyLXbyte();
                joyLy = con.readJoyLYbyte();

                led=!led;
                led_red = 0;
                led_green = 1;
                count_com_error = 0;
                enable = 1;
            } else {
                led=0;
                count_com_error++;
                if(count_com_error > 50) {
                    enable  = 0;
                    led_green = 0;
                    led_red = 1;
                    pc.printf("disconnected!!\r\n");
                    refV.x = 0;
                    refV.y = 0;
                    refV.z = 0;
                }
            }
            if((buttonState & MASK_BUTTON_PAD) == MASK_BUTTON_PAD) {
                absenc_1.setZeroPos();
                absenc_2.setZeroPos();
                absenc_3.setZeroPos();
            }
////////////////////////////指令値生成///////////////////////////////////////////
            refV = manualCon.getRefVel(joyLx,joyLy,joyRy);
            //activecaster_control(1,refV.x,refV.y,refV.z,abs_enc_rad(absenc_1.getEncount()));//車輪1の制御
            int encount_2 = absenc_2.getEncount();
            int encount_3 = absenc_3.getEncount();
            double enc_rad_2 = (double)encount_2 / ABS_ENCRES * PI * -2;
            double enc_rad_3 = (double)encount_3 / ABS_ENCRES * PI * -2;

            activecaster_control(2,refV.x,refV.y,refV.z,enc_rad_2);//車輪2の制御
            activecaster_control(3,refV.x,refV.y,refV.z,enc_rad_3);//車輪3の制御

            //pc.printf("count:%d enc_Rad_2:%.2lf",encount_2,enc_rad_2);
            pc.printf("x:%.2lf y:%.2lf z:%.2lf enc_2:%lf\r\n",refV.x,refV.y,refV.z,enc_rad_2);

            if (count >= 50) {
                pin_led_1 = !pin_led_1;
                pin_led_2 = !pin_led_2;
                count = 0;
            }
            flag10ms = false;
        }
        thread_sleep_for(1);
    }

}