#include "SDclass.h"

char REDpath[20] = "/fs/PATH_RED.txt";
char REDvel[20] = "/fs/VEL_RED.txt";
char BLUpath[20] = "/fs/PATH_BLU.txt";
char BLUvel[20] = "/fs/VEL_BLU.txt";

FATFileSystem fs("fs");
SDBlockDevice sd(P8_5, P8_6, P8_3, P8_4);

mySDclass::mySDclass() {}

/* SDカードの初期化 */
int mySDclass::init() {
  printf("mySDclass");

  if (fs.mount(&sd) == 0) {
    sd.frequency(2000000);
    SD_enable = true;
    printf(" init done");
    return 0;
  }

  printf(" init failure");
  return -1;
}

/* ログデータ書き出し用ファイル名の設定 */
int mySDclass::make_logfile() {
  // bool nameOK = false;
  int file_num = 0;

  DIR *d;
  d = opendir("/fs");
  if (d != NULL) {
    while (readdir(d) != NULL) {
      file_num++;
    }
  }

  int keta = 0;
  for(int tmp = file_num; (tmp /= 10) != 0; keta++);
  logFileName = "/fs/LOG_";
  for(int i = 0; i < (2 - keta); i++){
      logFileName += "0";
  }
  logFileName += to_string(file_num);
  logFileName += ".txt";
  //c_logFileName = logFileName.c_str();
  
  return file_num;
}

/* ログデータ書き出し用の関数 */
int mySDclass::write_logdata(string dataString) {
  FILE *dataFile = fopen(logFileName.c_str(), "w");

  if (dataFile) {
    fprintf(dataFile, dataString.c_str());
    fclose(dataFile);
    // Serial.println(dataString);
    return 0;
  } else {
    // Serial.println("error opening ");
    return -1;
  }
}

int mySDclass::path_read(int field, double Px[], double Py[], double vel[],
                         double angle[], int mode[], int count[],
                         double tbe[]) {
  FILE *myFile;
  char *pathFile;
  char *velFile;
  char tmpchar;
  char tmpA[10], tmpB[10], tmpC[10], tmpD[10], tmpE[10];
  bool file_end = false;
  int numa = 0, numb = 0, numc = 0, numd = 0, nume = 0;
  int path_num = 0, point_num = 0;

  // 赤か青かで読み込むファイルを変更する
  if (field == RED) {
    pathFile = REDpath; // 赤ゾーンのパス設定ファイル
    velFile = REDvel;   // 赤ゾーンの速度と角度の設定ファイル
  } else if (field == BLUE) {
    pathFile = BLUpath; // 青ゾーンのパス設定ファイル
    velFile = BLUvel;   // 青ゾーンの速度と角度の設定ファイル
  } else {
    return -1;
  }

  // パス設定用ファイルからデータを読み込む
  printf("openning... %s\n", pathFile);
  myFile = fopen(pathFile, "r");

  if (myFile) {
    // read from the file until there's nothing else in it:
    while (!file_end && !feof(myFile)) {
      while ((tmpchar = fgetc(myFile)) != ',') { // カンマが来るまで繰り返し
        tmpA[numa] = tmpchar; // 文字列に1文字ずつ格納していく
        numa++;
      }
      *Px = str2double(tmpA, numa); //関数でdoubleに変換
      // Serial.print(tmpA);
      printf("%lf, ", *Px);
      for (int i = 0; i < 10; i++)
        tmpA[i] = 0; // 文字列を初期化
      numa = 0;
      Px++;
      while (((tmpchar = fgetc(myFile)) != '\r' && tmpchar != ';') && tmpchar != '/') { // 改行コードかセミコロン，スラッシュが来るまで繰り返し
        tmpB[numb] = tmpchar;
        numb++;
      }
      if (tmpchar == ';') {
        file_end = true;
      } else if (tmpchar == '/') { // コメントアウト対応
        while ((tmpchar = fgetc(myFile)) != '\n');
      } else {
        fgetc(myFile); // "\n"を捨てるため
      }
      *Py = str2double(tmpB, numb); //関数でdoubleに変換
      point_num++;

      printf("%lf\n", *Py);
      // Serial.println(tmpB);
      for (int i = 0; i < 10; i++)
        tmpB[i] = 0;
      numb = 0;
      Py++;
    }
    // Serial.print("path done! ");
    file_end = false;
    //   the file:
    fclose(myFile);
  } else {
    // if the file didn't open, print an error:
    // Serial.println("error opening test.txt");
    return -2;
  }
  printf("point num: %d\n", point_num);

  // 速度設定用ファイルからデータを読み込む
  printf("openning... %s\n", velFile);
  myFile = fopen(velFile, "r");
  if (myFile) {
    while (!file_end && !feof(myFile)) {
      while ((tmpchar = fgetc(myFile)) != ',') {
        tmpA[numa] = tmpchar;
        numa++;
      }
      *vel = str2double(tmpA, numa); //関数でdoubleに変換
      // Serial.print(tmpA);
      printf("%lf, ", *vel);
      for (int i = 0; i < 10; i++)
        tmpA[i] = 0;
      numa = 0;
      vel++;
      //////////////////////////////////
      while ((tmpchar = fgetc(myFile)) != ',') {
        tmpB[numb] = tmpchar;
        numb++;
      }
      *angle = str2double(tmpB, numb); //関数でdoubleに変換
      // Serial.print(tmpA);
      printf("%lf, ", *angle);
      for (int i = 0; i < 10; i++)
        tmpB[i] = 0;
      numb = 0;
      angle++;
      //////////////////////////////////
      while ((tmpchar = fgetc(myFile)) != ',') {
        tmpC[numc] = tmpchar;
        numc++;
      }
      *mode = str2uint(tmpC, numc); //関数でdoubleに変換
      // Serial.print(tmpA);
      printf("%d, ", *mode);
      for (int i = 0; i < 10; i++)
        tmpC[i] = 0;
      numc = 0;
      mode++;
      //////////////////////////////////
      while ((tmpchar = fgetc(myFile)) != ',') {
        tmpD[numd] = tmpchar;
        numd++;
      }
      *count = str2uint(tmpD, numd); //関数でdoubleに変換
      // Serial.print(tmpA);
      printf("%d, ", *count);
      for (int i = 0; i < 10; i++)
        tmpD[i] = 0;
      numd = 0;
      count++;
      //////////////////////////////////
      while (((tmpchar = fgetc(myFile)) != '\r' && tmpchar != ';') &&
             tmpchar != '/') {
        tmpE[nume] = tmpchar;
        nume++;
      }
      if (tmpchar == ';') {
        file_end = true;
      } else if (tmpchar == '/') { // コメントアウト対応
        while ((tmpchar = fgetc(myFile)) != '\n');
      } else {
        fgetc(myFile); // "\n"を捨てるため
      }
      *tbe = str2double(tmpE, nume); //関数でdoubleに変換
      path_num++;

      // Serial.print(tmpB);
      printf("%lf\n", *tbe);
      for (int i = 0; i < 10; i++)
        tmpE[i] = 0;
      nume = 0;
      tbe++;
    }
    // Serial.println("vel/angle done!");
    // close the file:
    fclose(myFile);
  } else {
    // if the file didn't open, print an error:
    // Serial.println("error opening test.txt");
    return -3;
  }

  if ((int)((point_num - 2) / 3) >= (path_num - 1)) {
    return path_num - 1;
  }
  return -4;
}

double mySDclass::str2double(char *str, int num) {
  double ret = 0.0;
  bool minus = false;
  int m = 0, keta;

  // マイナス符号が付いているかチェック
  if (str[0] == '-') {
    minus = true;
    m++;
  }

  // 何桁あるかを確認
  keta = m;
  while ((str[keta] != '.') && (keta < num)) {
    keta++;
  }
  keta = keta - (m + 1);

  // 整数部を変換
  for (int i = m; i <= (keta + m); i++) {
    if (str[i] >= 48 && str[i] <= 57) {
      ret += (double)(str[i] - 48) * pow(10.0, keta - (i - m));
    }
  }

  // 小数部を変換
  int n = -1;
  for (int i = keta + m + 2; i < num; i++) {
    if (str[i] >= 48 && str[i] <= 57) {
      ret += (double)(str[i] - 48) * pow(10.0, n);
      n--;
    }
  }
  if (minus)
    return -1.0 * ret;
  return ret;
}

int mySDclass::str2uint(char *str, int num) {
  num--;
  int ret = 0;
  // bool minus = false;

  // 整数部を変換
  for (int i = 0; i <= num; i++) {
    if (str[i] >= 48 && str[i] <= 57) {
      ret += (double)(str[i] - 48) * pow(10.0, num - i);
    }
  }

  return ret;
}
