#include "mbed.h"
#include "define.h"
#include "DDSScontrol.h"
#include "math.h"

DDSS::DDSS(PinName _pwm_a,PinName _pwm_b,PinName _dir_a,PinName _dir_b) : pwm_a(_pwm_a),pwm_b(_pwm_b),dir_a(_dir_a),dir_b(_dir_b)//コンストラクタ ピン番号を引数にする
{
    pwm_a.write(0.0);
    pwm_b.write(0.0);
    dir_a.write(0);
    dir_b.write(0);
}

void DDSS::setposi(double _Wp_x,double _Wp_y)//操舵点の座標を渡す
{
    Wp_x = _Wp_x;
    Wp_y = _Wp_y;
}

void DDSS::control(double _refVx,double _refVy,double _refVz,double _stear_angle)//実際に制御を行う
{
    refVx = _refVx;
    refVy = _refVy;
    refVz = _refVz;
    stear_angle = _stear_angle;

    V_x = refVx - Wp_y * refVz;//操舵点の速度決定
    V_y = refVy + Wp_x * refVz;

    omega_wheel = (V_x * cos(stear_angle) + V_y * sin(stear_angle)) / WHEEL_R;//操舵角速度
    omega_stear = (-V_x * sin(stear_angle) + V_y * cos(stear_angle)) / OFFSET;//走行角速度

    omega_a = GEAR_RATIO_TRANS * omega_wheel - GEAR_RATIO_TRANS * omega_stear;//モーターAの角速度
    omega_b = GEAR_RATIO_TRANS * omega_wheel + GEAR_RATIO_TRANS * omega_stear;//モーターBの角速度

    rpm_a = omega_a * 9.554;//角速度から回転数(rpm)に換算するところ
    rpm_b = omega_b * 9.554;

    MD_val_a = fabs(rpm_a) * 0.8 / MAX_RPM+0.1;//ESCONの指令値に変換する処理
    MD_val_b = fabs(rpm_b) * 0.8 / MAX_RPM+0.1;

    MD_val_a = MD_val_a > 0.9 ? MD_val_a = 0.9 : MD_val_a;//ESCONのPWM指令は10%から90%の間で有効なのでその範囲に収める処理
    MD_val_a = MD_val_a < 0.1 ? MD_val_a = 0.1 : MD_val_a;
    MD_val_b = MD_val_b > 0.9 ? MD_val_b = 0.9 : MD_val_b;
    MD_val_b = MD_val_b < 0.1 ? MD_val_b = 0.1 : MD_val_b;
    
    rpm_a > 0 ? dir_a.write(1):dir_a.write(0);//回転方向の指定
    rpm_b > 0 ? dir_b.write(1):dir_b.write(0);
    
    pwm_a.write(MD_val_a);//PWM出力処理
    pwm_b.write(MD_val_b);

}