#ifndef MD_PID_H_
#define MD_PID_H_

#include <shared/MD/MD.h>
#include <shared/QEI/QEI.h>
#include "PID.h"
#include "PPID.h"
#include "PI_D.h"

class MD_PID
{
public:
    MD_PID( MD *md, QEI *qei,
            double k = 0, double ti = 0, double td = 0,
			double max_speed = 0);
    virtual void drive(double target, double interval);
    virtual void brake(double target);
    virtual void free();
    void set_max_speed(double max_speed);
    
    double get_duty();
    
private:
    MD *_md;
    QEI *_qei;
    PID *_pid;
    double _duty;
    double _max_speed;
    
    double read_vel();
};

#endif
