/*
 * MAIN.CPP
 */
#include "mbed.h"

#include "TextLCD.h"
#include "Distance_HC_SR04.h"


int main() {

    TextLCD lcd(PA_8, PA_7, PA_9, PA_1, PB_5, PA_10, TextLCD::LCD16x2);
    
    wait_ms(250);
    lcd.cls();

    Distance_HC_SR04 distFront(PB_9, PA_6);
    uint32_t ticks_us;
    float distance;

    while (true) {
        ticks_us = distFront.measureTicks();
        distance = distFront.getDistance();

        lcd.cls();

        switch (distFront.getState()) {
            case COMPLETED:
                lcd.printf("Dist.: %u", ticks_us);
                lcd.locate(0, 1);
                lcd.printf("Dist.: %.3f", distance);

                break;

            case TIMEOUT:
                lcd.printf("Dist.: ---");
                lcd.locate(0, 1);
                lcd.printf("TIMEOUT");

                break;

            case ERROR_SIG:
                lcd.printf("Dist.: ---");
                lcd.locate(0, 1);
                lcd.printf("ERROR_SIG");

                break;

            case OUT_OF_RANGE_MIN:
                lcd.printf("Dist.: ---");
                lcd.locate(0, 1);
                lcd.printf("OUT_OF_RANGE_MIN");

                break;

            case OUT_OF_RANGE_MAX:
                lcd.printf("Dist.: ---");
                lcd.locate(0, 1);
                lcd.printf("OUT_OF_RANGE_MAX");

                break;

            default:
                lcd.printf("Dist.: ---");
                lcd.locate(0, 1);
                lcd.printf("OTHER");

                break;
        }
        wait_ms(100);
    }
}
