/*
 * TSK_MAIN.CPP
 */
#include "mbed.h"
#include "rtos.h"

#include "tsk_button.h"
#include "tsk_display.h"
#include "tsk_dist.h"
#include "tsk_led.h"
#include "tsk_temp.h"
#include "tsk_inttemp.h"

#define TASKS_NUMBER    (sizeof(taskList)/sizeof(taskList[0]))

uint32_t uiCnt = 0;
Mutex mutexDist;
Mutex mutexTemp;
Mutex mutexIntTemp;

struct task_definition_struct {
    void(*task)(void const *args);
    uint32_t(*init)(void const *args); // Result: 1 = OK, 0 = FAIL
    void *task_args;                   // NULL For DEFAULT (NULL)
    void *init_args;                   // NULL For DEFAULT (NULL)
    osPriority priority;
//    uint32_t stack_size;               // 0 for DEFAULT (DEFAULT_STACK_SIZE)
//    unsigned char *stack_pointer;      // NULL for DEFAULT (NULL)
    uint32_t delay;                    // Delay on start from previous task
    Thread *thread;                    // To be filled in during runtime
    uint32_t retVal;                   // Return Value - to be filled in during runtime
};

static struct task_definition_struct taskList[] = {
//    { dist_thread,    &initDist,       NULL, NULL, osPriorityNormal, 100, NULL, 0 },
    { temp_thread,    &initDS1620Temp, NULL, NULL, osPriorityNormal, 100, NULL, 0 },
    { inttemp_thread, &initIntTemp,    NULL, NULL, osPriorityNormal, 100, NULL, 0 },
//    { button_thread,  NULL,            NULL, NULL, osPriorityNormal, 0, NULL, 0 },
    { led_thread,     &initLed,        NULL, NULL, osPriorityNormal, 100, NULL, 0 },
    { disp_thread,    &initDisplay,    NULL, NULL, osPriorityNormal, 100, NULL, 0 },
};

static uint32_t initTasks(void) {
    uint32_t i;
    uint32_t retval = 1;
    
    for (i = 0; i < TASKS_NUMBER; i++) {
        if (taskList[i].init != NULL) {
            if ((taskList[i].retVal = ((*taskList[i].init)(taskList[i].init_args))) == 0)
                retval = 0;
        } else {
            taskList[i].retVal = 1;
        }
    }
            
    for (i = 0; i < TASKS_NUMBER; i++) {
        Thread::wait(taskList[i].delay);

        if (taskList[i].retVal == 1) {
            taskList[i].thread = new Thread(taskList[i].task, taskList[i].task_args, taskList[i].priority );
        }
    }
    
    return retval;
}


int main() {
    
    initTasks();

    Thread::wait(osWaitForever);

    disposeDisplay(NULL);
}
 
