/*
 * TSK_DIST.CPP
 */
#include "mbed.h"
#include "rtos.h"

#include "tsk_main.h"
#include "tsk_dist.h"


struct dist_data_struct dist_data;

static DigitalOut  trigDist(PB_9);
static InterruptIn echoDist(PA_6);

static Timer timer;

uint32_t initDist(void const *args) {
    
    dist_data.distance = 0.0f;
    dist_data.timerTicks = 0;

    trigDist = 0;
    
    return 1;
}

static void rising(void) {
    timer.start();
}

static void falling(void) {
    timer.stop();
    echoDist.rise(0);
    echoDist.fall(0);

//    mutexDist.lock();
    dist_data.timerTicks = timer.read_us();
        
    // 340 ms-1
    dist_data.distance = (timer.read()/2.0f - 0.0f)*340.0f*1000.0f;
//    mutexDist.unlock();

    // Vynuluj timer
    timer.reset();
}

void dist_thread(void const *args) {
    
    while (true) {    
        // Dej puls na trig
        trigDist = 1;
        Thread::wait(1);
        trigDist = 0;
    
        if (echoDist != 0) {
            mutexDist.lock();
            dist_data.timerTicks = 0;
            dist_data.distance = 0.0f;
            mutexDist.unlock();
        } else {
            // Vynuluj timer
            timer.stop();
            timer.reset();
                
            // Cekej na hrany na Echo
            echoDist.rise(&rising);
            echoDist.fall(&falling);
        }
        
        Thread::wait(1000);
    }
}
