/*
 * TSK_BUTTON.CPP
 */
#include "mbed.h"
#include "rtos.h"

#include "tsk_button.h"
#include "tsk_led.h"

static DigitalIn   button1(USER_BUTTON);


void button_thread(void const *args) {
    static uint32_t last_state = button1;
    uint32_t temp;
            
    while (true) {
        if (button1 != last_state) {
            temp = led_flash_times.on_time;
            led_flash_times.on_time = led_flash_times.off_time;
            led_flash_times.off_time = temp;
        }
        
        Thread::wait(500);
    }
}

