/*
 * TSK_DISPLAY.CPP
 */
#include "mbed.h"
#include "rtos.h"

#include "TextLCD.h"

#include "tsk_main.h"
#include "tsk_display.h"
#include "tsk_temp.h"
#include "tsk_inttemp.h"
#include "tsk_dist.h"

static TextLCD *lcd;

uint32_t initDisplay(void const *args) {

    lcd = new TextLCD(PA_8, PA_7, PA_9, PA_1, PB_5, PA_10, TextLCD::LCD16x2);

    wait_ms(250);
    lcd->cls();
       
    return 1;
}

uint32_t disposeDisplay(void const *args) {

    delete lcd;
    lcd = NULL;
       
    return 1;
}


void disp_thread(void const *args) {
    float dist;
    float temp;
    float intTemp;
    uint32_t dist_raw;
    uint32_t temp_raw;
    
    while (true) {
        mutexDist.lock();
        dist = dist_data.distance;
        dist_raw = dist_data.timerTicks;
        mutexDist.unlock();

        mutexTemp.lock();
        temp = temp_data.temperature;
        temp_raw = temp_data.temp_raw;
        mutexTemp.unlock();

        mutexIntTemp.lock();
        intTemp = int_temp_data.temperature;
        mutexIntTemp.unlock();

        uiCnt += 2;

        lcd->cls();
//        lcd->printf("%4.2fmm (%4u)", dist, dist_raw);
        lcd->printf("%4.2fmm (%4u)", dist, uiCnt);
        lcd->locate(0, 1);    
//        lcd->printf("%3.2f%cC (%3u)", temp, 0xdf, temp_raw);
        lcd->printf("%3.1f%cC (%2.1f)", temp, 0xdf, intTemp);

        Thread::wait(2000);
    }
}
