/*
 * TSK_INTTEMP.CPP
 */
#include "mbed.h"
#include "rtos.h"
#include "stm32f411xe.h"

#include "tsk_main.h"
#include "tsk_inttemp.h"


struct int_temp_data_struct int_temp_data = { 0 };


uint32_t initIntTemp(void const *args) {
    
    int_temp_data.temperature = 0.0f;
    
    //enable ADC1 clock
    SET_BIT(RCC->APB2ENR, RCC_APB2ENR_ADC1EN);

    // ADC on
    SET_BIT(ADC1->CR2, ADC_CR2_ADON);
    CLEAR_BIT(ADC1->CR2, ADC_CR2_CONT);
    
    // Temp sensor on
    CLEAR_BIT(ADC->CCR, ADC_CCR_VBATE);
    SET_BIT(ADC->CCR, ADC_CCR_TSVREFE);
    
    CLEAR_BIT(ADC1->CR1, ADC_CR1_RES);
    
    return 1;
}

static uint16_t getADCTemp() {
    // Set channel
    ADC1->SQR1 &= ~ADC_SQR1_L;  // Count = 1
    ADC1->SQR3 |= ADC_SQR3_SQ1 & 18;

    // Start conversion
    SET_BIT(ADC1->CR2, ADC_CR2_SWSTART);
    
    // Wait for completion
    while (!READ_BIT(ADC1->SR, ADC_SR_EOC))
        ;
        
    // Return result
    return READ_REG(ADC1->DR);
}


void inttemp_thread(void const *args) {

    const float     V25 = 943.3212f;// when V25=1.41V at ref 3.3V (0,76V)
    const float     Avg_Slope = 3.1030303f; //when avg_slope=4.3mV/C at ref 3.3V  (2.5mV/C)
    const uint16_t  bufferSize = 4;

    float       temp;
    uint16_t    i;
    uint16_t    uiCnt = 0;

    
    while (true) {
        for (i = 0, temp = 0.0f; i < bufferSize; i++) {
            temp += ((float)getADCTemp() - V25) / Avg_Slope + 48.2f;
            Thread::wait(100);
        }
        temp /= (float)bufferSize;
     
        mutexIntTemp.lock();
        int_temp_data.temperature = temp;
        mutexIntTemp.unlock();
        
        Thread::wait(5000);
    }
}
